/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.healthmanage.cluster.redis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.keepalive.LivingKeeperUtils;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.healthmanage.ServiceHealthIndicatorConfig;
import kd.bos.mservice.monitor.healthmanage.cluster.ClusterHealth;
import kd.bos.mservice.monitor.healthmanage.cluster.ClusterNotifyHealth;
import kd.bos.mservice.monitor.healthmanage.cluster.InstanceHealthInfo;
import kd.bos.mservice.monitor.healthmanage.config.HealthConfig;
import kd.bos.mservice.monitor.healthmanage.indicator.WorstIndicatorInfo;
import kd.bos.redis.JedisClient;

public class ClusterNotifyHealthRedis
implements ClusterNotifyHealth {
    private final String INSTANCEKEY = LivingKeeperUtils.PRE + Instance.getInstanceId();
    private final Map<String, String> instanceHosts = ClusterHealth.getInstancehostsMap();
    private final Map<String, Long> instanceLastestUpdate = new ConcurrentHashMap<String, Long>(4);
    private final Map<String, Long> lastestFeatchTime = new ConcurrentHashMap<String, Long>(4);
    private final Map<String, Boolean> initAppNames = new ConcurrentHashMap<String, Boolean>(4);
    private static final String CLUSTERHEALTHKEY = "clusterNodeHealthValue-" + Instance.getClusterName();
    private static final String CLUSTERAPPNAMESPREKEY = "clusterAppNames-" + Instance.getClusterName() + "-";
    private static final String splitkey = "##";
    private static Log log = LogFactory.getLog(ServiceHealthIndicatorConfig.class);

    @Override
    public void broadcastHealth(WorstIndicatorInfo worst) {
        try (JedisClient jedis = LivingKeeperUtils.createLivingMonitorJedisClient();){
            jedis.hset(CLUSTERHEALTHKEY, this.INSTANCEKEY, String.valueOf(System.currentTimeMillis()) + splitkey + String.valueOf(worst.getLevel()));
            this.initAppNames.computeIfAbsent(this.getClusterAppNameKey(), k -> {
                jedis.sadd(k, new String[]{Instance.getAppName()});
                jedis.expireAt(k, System.currentTimeMillis() + 86400000L);
                return Boolean.TRUE;
            });
        }
        catch (Exception e) {
            log.error("broadcastHealth error", (Throwable)e);
        }
    }

    @Override
    public void receiveHealth() {
        try (JedisClient jedis = LivingKeeperUtils.createLivingMonitorJedisClient();){
            Map m = jedis.hgetAll(CLUSTERHEALTHKEY);
            ArrayList<InstanceHealthInfo> healthls = new ArrayList<InstanceHealthInfo>(2);
            for (Map.Entry entry : m.entrySet()) {
                String instanceKey = (String)entry.getKey();
                String[] values = ((String)entry.getValue()).split(splitkey);
                long lastTime = Long.parseLong(values[0]);
                int level = Integer.parseInt(values[1]);
                String instanceid = instanceKey.substring(LivingKeeperUtils.PRE.length());
                this.instanceHosts.computeIfAbsent(instanceid, key -> {
                    String host = jedis.get(instanceKey);
                    return host != null && host.length() > 0 ? host : null;
                });
                InstanceHealthInfo healthInfo = new InstanceHealthInfo();
                healthls.add(healthInfo);
                healthInfo.setInstanceId(instanceid);
                healthInfo.setInstanceUpdateTime(lastTime);
                healthInfo.setCurTouchTime(System.currentTimeMillis());
                Long lastupdate = this.instanceLastestUpdate.get(instanceid);
                if (lastupdate == null) {
                    this.instanceLastestUpdate.put(instanceid, lastTime);
                    this.lastestFeatchTime.put(instanceid, System.currentTimeMillis());
                    healthInfo.setLevel(level);
                    continue;
                }
                if (lastupdate.equals(lastTime)) {
                    long durationTime = System.currentTimeMillis() - this.lastestFeatchTime.get(instanceid);
                    if (durationTime > (long)(HealthConfig.getBroadcastNotifyInterval() * 1000 * 3)) {
                        jedis.hdel(CLUSTERHEALTHKEY, new String[]{instanceKey});
                        healthInfo.setLevel(HealthLevel.ERROR.getLevel());
                        continue;
                    }
                    if (durationTime > (long)(HealthConfig.getBroadcastNotifyInterval() * 1000)) {
                        healthInfo.setLevel(HealthLevel.OVERLOAD.getLevel());
                        continue;
                    }
                    healthInfo.setLevel(level);
                    continue;
                }
                this.instanceLastestUpdate.put(instanceid, lastTime);
                this.lastestFeatchTime.put(instanceid, System.currentTimeMillis());
                healthInfo.setLevel(level);
            }
            ClusterHealth.updateHealth(healthls);
        }
        catch (Exception e) {
            log.error("broadcastHealth error", (Throwable)e);
        }
    }

    private String getClusterAppNameKey() {
        return CLUSTERAPPNAMESPREKEY + System.currentTimeMillis() / 100000000L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> getClusterAppName() {
        try (JedisClient jedis = LivingKeeperUtils.createLivingMonitorJedisClient();){
            Set set = jedis.smembers(this.getClusterAppNameKey());
            return set;
        }
        catch (Exception e) {
            log.error("getClusterAppName error", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @Override
    public Set<String> getClusterAppIds() {
        try (JedisClient jedis = LivingKeeperUtils.createLivingMonitorJedisClient();){
            Map m = jedis.hgetAll(CLUSTERHEALTHKEY);
            if (m != null) {
                HashSet<String> rset = new HashSet<String>(2);
                for (String key : m.keySet()) {
                    try {
                        rset.add(key.substring(LivingKeeperUtils.PRE.length()));
                    }
                    catch (Exception e) {
                        log.error("get cluster appids error", (Throwable)e);
                    }
                }
                HashSet<String> hashSet = rset;
                return hashSet;
            }
            Set set = Collections.EMPTY_SET;
            return set;
        }
    }
}

