/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.healthmanage.indicator;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import kd.bos.instance.Instance;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.LimitQueue;
import kd.bos.mservice.monitor.healthmanage.ServiceHealthIndicatorDef;
import kd.bos.mservice.monitor.healthmanage.config.CommonIndicatorItemConfig;
import kd.bos.mservice.monitor.healthmanage.config.ConfigItemMeta;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorConfigurable;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorItemConfig;
import kd.bos.mservice.monitor.items.Indicator;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.mservice.monitor.lang.LangSupplier;
import kd.bos.util.JmxUtils;
import kd.bos.util.WebPortUtil;

public class ConfigurationIndicator
implements Indicator,
IndicatorConfigurable {
    private ServiceHealthIndicatorDef healthIndicator;
    private ItemConfig config = new ItemConfig();
    private final String name;
    private final Supplier<String> desc;
    private Long highLevel;
    private final LimitQueue<Double> cacheStatus = new LimitQueue(20);
    private static final String CPU = "cpu";
    private static final String MEMORY = "memory";
    private static final String ACTIVEREQUESTS = "activeRpcRequests";

    public ConfigurationIndicator(ServiceHealthIndicatorDef healthIndicator) {
        this.healthIndicator = healthIndicator;
        String key = healthIndicator.getObjectName() + "." + healthIndicator.getAttributeName();
        if (key.endsWith("ProcessCpuLoad")) {
            this.name = CPU;
            this.desc = new LangSupplier(LangRes.healthmanage, "ConfigurationIndicator_3", "CPU usage rate, when this indicator exceeds the threshold, the node is considered busy or overloaded");
        } else if (key.endsWith("HeapMemoryUsage")) {
            this.name = MEMORY;
            this.desc = new LangSupplier(LangRes.healthmanage, "ConfigurationIndicator_4", "JVM memory usage rate, when this indicator exceeds the threshold, the node is considered busy or overloaded");
        } else if (key.indexOf("activeRequests") > 0) {
            this.name = ACTIVEREQUESTS;
            this.desc = new LangSupplier(LangRes.healthmanage, "ConfigurationIndicator_5", "RPC thread pool usage rate, when this indicator exceeds the threshold, the node is considered busy or overloaded");
        } else {
            this.name = key;
            this.desc = () -> key;
        }
    }

    public void init() {
        this.highLevel = this.healthIndicator.getHighlevelline();
    }

    @Override
    public HealthLevel getHealthLevel() {
        Double avgIndicator = this.cacheStatus.getLast();
        if (avgIndicator == null) {
            return HealthLevel.NORMAL;
        }
        double percentValue = avgIndicator / (double)this.highLevel.longValue();
        if (percentValue <= this.config.normalMaxValue / 100.0) {
            return HealthLevel.NORMAL;
        }
        if (percentValue <= this.config.busyMaxValue / 100.0) {
            return HealthLevel.BUSY;
        }
        return HealthLevel.OVERLOAD;
    }

    private double getAvgIndicator() {
        Double indicator = this.getIndicator();
        int itemsize = this.cacheStatus.size();
        if (itemsize == 0) {
            return indicator;
        }
        Double preindicators = this.cacheStatus.getLast();
        double avgval = (preindicators * (double)itemsize + indicator) / (double)(itemsize + 1);
        return avgval;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDesc() {
        return this.getName() + ":" + this.desc.get();
    }

    public ServiceHealthIndicatorDef getHealthIndicator() {
        return this.healthIndicator;
    }

    @Override
    public void touch() {
        this.cacheStatus.offer(this.getAvgIndicator());
    }

    private Double getIndicator() {
        Object obj = WebPortUtil.isWebNode() && !Instance.isWebMserviceInOne() && this.healthIndicator.isOnlymservice() ? "1" : (this.healthIndicator.getPath() == null || this.healthIndicator.getPath().length() == 0 ? JmxUtils.getAtt((String)this.healthIndicator.getObjectName(), (String)this.healthIndicator.getAttributeName()) : JmxUtils.getAtt((String)this.healthIndicator.getObjectName(), (String)this.healthIndicator.getAttributeName(), (String)this.healthIndicator.getPath()));
        Double d = new Double(obj == null ? "0" : obj.toString());
        return d;
    }

    @Override
    public boolean canResponse() {
        int healthThreshold;
        double avgIndicator = this.getAvgIndicator();
        double percentValue = 100.0 * avgIndicator / (double)this.highLevel.longValue();
        return !(percentValue > (double)(healthThreshold = this.getThreashold(this.healthIndicator)));
    }

    private int getThreashold(ServiceHealthIndicatorDef def) {
        String key = this.name;
        String thresholdKey = "service.health.threshold";
        String thresholdValue = System.getProperty(thresholdKey + "." + key);
        if (thresholdValue == null) {
            thresholdValue = System.getProperty(thresholdKey, "95");
        }
        return Integer.parseInt(thresholdValue);
    }

    @Override
    public boolean isOnlyMservice() {
        return this.healthIndicator.isOnlymservice();
    }

    @Override
    public boolean $configEnable() {
        return this.config.isEnable();
    }

    @Override
    public String getHealthDetail() {
        Double cur = this.cacheStatus.getLast();
        BigDecimal bg = BigDecimal.valueOf(cur).setScale(2, 4);
        BigDecimal percent = BigDecimal.valueOf(bg.doubleValue() * 100.0 / (double)this.highLevel.longValue()).setScale(0, 4);
        if (MEMORY.equals(this.name)) {
            bg = bg.divide(BigDecimal.valueOf(0x100000L)).setScale(2, 4);
            return "high: " + this.highLevel / 1024L / 1024L + "MB,used: " + bg + "MB, percent: " + percent + "%";
        }
        return "high: " + this.highLevel + ",used: " + bg + ", percent: " + percent + "%";
    }

    @Override
    public IndicatorItemConfig getIndicatorConfig() {
        return this.config;
    }

    @Override
    public Set<String> getAssistDiagnoseType() {
        HashSet<String> s = new HashSet<String>(2);
        if (CPU.endsWith(this.name)) {
            s.add("topthread");
        } else if (MEMORY.endsWith(this.name)) {
            s.add("topthread");
        } else if (ACTIVEREQUESTS.endsWith(this.name)) {
            s.add("backendthreadstack");
        }
        return s;
    }

    private static class ItemConfig
    extends CommonIndicatorItemConfig {
        private double normalMaxValue = 80.0;
        private double busyMaxValue = 95.0;

        private ItemConfig() {
        }

        @Override
        public void initFieldMeta() {
            super.initFieldMeta();
            ConfigItemMeta normalMaxValueFiledMeta = new ConfigItemMeta("normalMaxValue").withDefaultValue(80).withDisplayLabelName(new LangSupplier(LangRes.healthmanage, "ConfigurationIndicator_1", "Normal state maximum percentage threshold (%)"));
            this.initInfosMap.put(normalMaxValueFiledMeta.getFiledName(), normalMaxValueFiledMeta);
            ConfigItemMeta busyMaxValueFiledMeta = new ConfigItemMeta("busyMaxValue").withDefaultValue(95).withDisplayLabelName(new LangSupplier(LangRes.healthmanage, "ConfigurationIndicator_2", "Busy state maximum percentage threshold (%)"));
            this.initInfosMap.put(busyMaxValueFiledMeta.getFiledName(), busyMaxValueFiledMeta);
        }
    }
}

