/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.healthmanage.indicator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.db.datasource.DataSourceFactory;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.healthmanage.config.CommonIndicatorItemConfig;
import kd.bos.mservice.monitor.healthmanage.config.ConfigItemMeta;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorConfigurable;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorItemConfig;
import kd.bos.mservice.monitor.items.Indicator;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.mservice.monitor.lang.LangSupplier;

public class DBPoolIndicator
implements Indicator,
IndicatorConfigurable {
    private AtomicInteger totaoWaitCount = new AtomicInteger(0);
    private AtomicLong touchx = new AtomicLong(0L);
    private ItemConfig config = new ItemConfig();

    @Override
    public HealthLevel getHealthLevel() {
        if (this.totaoWaitCount.get() > this.config.overloadMaxWaitCount) {
            return HealthLevel.ERROR;
        }
        if (this.totaoWaitCount.get() > this.config.normalMaxWaitCount) {
            return HealthLevel.OVERLOAD;
        }
        Map<String, Map<String, Object>> conResult = this.getBusyConPool();
        if (!conResult.isEmpty()) {
            return HealthLevel.BUSY;
        }
        return HealthLevel.NORMAL;
    }

    private Map<String, Map<String, Object>> getBusyConPool() {
        Map conDetailStautsMap = DataSourceFactory.dumpDetailStatus();
        HashMap<String, Map<String, Object>> conResult = new HashMap<String, Map<String, Object>>(1);
        conDetailStautsMap.forEach((k, m) -> {
            int poolMaxActive = (Integer)m.get("pooMaxActive");
            int activeCount = (Integer)m.get("activeCount");
            int waitCount = (Integer)m.get("waitCount");
            if (waitCount > 0 || activeCount >= poolMaxActive - 1) {
                conResult.put((String)k, (Map<String, Object>)m);
            }
        });
        return conResult;
    }

    @Override
    public String getName() {
        return "dbpool";
    }

    @Override
    public String getDesc() {
        return this.getName() + ":" + LangRes.healthmanage.getString("DBPOolIndicator_1", "Database connection pool usage indicator, when there is a connection waiting, the node is considered busy or overloaded", new Object[0]);
    }

    @Override
    public void touch() {
        if (this.touchx.incrementAndGet() % 5L == 0L) {
            Map<Thread, StackTraceElement[]> allThreads = Thread.getAllStackTraces();
            AtomicInteger waitCount = new AtomicInteger(0);
            allThreads.values().forEach(elements -> {
                if (DBPoolIndicator.isStatckElementsForDBWait(elements)) {
                    waitCount.incrementAndGet();
                }
            });
            this.totaoWaitCount.set(waitCount.get());
        }
    }

    public static boolean isStatckElementsForDBWait(StackTraceElement[] elements) {
        for (int i = 0; i < 20 && i < elements.length; ++i) {
            StackTraceElement element = elements[i];
            if (!"getConnection".equals(element.getMethodName()) || element.getClassName().indexOf("DataSource") < 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canResponse() {
        return true;
    }

    @Override
    public boolean isOnlyMservice() {
        return false;
    }

    @Override
    public String getHealthDetail() {
        if (this.getHealthLevel() == HealthLevel.NORMAL) {
            return " No db pool wait ";
        }
        Map<String, Map<String, Object>> conResult = this.getBusyConPool();
        StringBuilder sb = new StringBuilder("total db pool wait is ");
        sb.append(this.totaoWaitCount.get()).append(", ");
        conResult.forEach((k, v) -> sb.append((String)k).append(" -> ").append(v).append(" \r\n "));
        return sb.toString();
    }

    @Override
    public IndicatorItemConfig getIndicatorConfig() {
        return this.config;
    }

    @Override
    public Set<String> getAssistDiagnoseType() {
        HashSet<String> s = new HashSet<String>(2);
        s.add("dbactiveconnection");
        return s;
    }

    private static class ItemConfig
    extends CommonIndicatorItemConfig {
        private int normalMaxWaitCount = 5;
        private int overloadMaxWaitCount = 50;

        private ItemConfig() {
        }

        @Override
        public void initFieldMeta() {
            super.initFieldMeta();
            ConfigItemMeta normalMaxValueFiledMeta = new ConfigItemMeta("normalMaxValue").withDefaultValue(50).withDisplayLabelName(new LangSupplier(LangRes.healthmanage, "DBPoolIndicator_2", "Maximum connection wait in busy state"));
            this.initInfosMap.put(normalMaxValueFiledMeta.getFiledName(), normalMaxValueFiledMeta);
            ConfigItemMeta busyMaxValueFiledMeta = new ConfigItemMeta("busyMaxValue").withDefaultValue(150).withDisplayLabelName(new LangSupplier(LangRes.healthmanage, "DBPoolIndicator_3", "Maximum connection wait in overloaded state"));
            this.initInfosMap.put(busyMaxValueFiledMeta.getFiledName(), busyMaxValueFiledMeta);
        }
    }
}

