/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.healthmanage.indicator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.metric.MetricSystem;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.action.Action;
import kd.bos.mservice.monitor.action.ActionFactory;
import kd.bos.mservice.monitor.action.ActionParam;
import kd.bos.mservice.monitor.healthmanage.config.CommonIndicatorItemConfig;
import kd.bos.mservice.monitor.healthmanage.config.ConfigItemMeta;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorConfigurable;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorItemConfig;
import kd.bos.mservice.monitor.items.Indicator;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.mservice.monitor.lang.LangSupplier;
import kd.bos.thread.OutOfMemoryObserver;
import kd.bos.util.EnvUtils;
import kd.bos.util.ExceptionUtils;

public class OOMIndicator
implements Indicator,
IndicatorConfigurable {
    private ItemConfig config = new ItemConfig();

    @Override
    public HealthLevel getHealthLevel() {
        if (OutOfMemoryObserver.hasOOM()) {
            return HealthLevel.ERROR;
        }
        return HealthLevel.NORMAL;
    }

    @Override
    public String getName() {
        return "oom";
    }

    @Override
    public String getDesc() {
        return this.getName() + ":" + LangRes.healthmanage.getString("OOMIndicator_1", "When OOM occurs, the node is abnormal", new Object[0]);
    }

    @Override
    public void touch() {
    }

    @Override
    public boolean canResponse() {
        return !OutOfMemoryObserver.hasOOM();
    }

    @Override
    public boolean isOnlyMservice() {
        return false;
    }

    @Override
    public String getHealthDetail() {
        if (OutOfMemoryObserver.hasOOM()) {
            return "error case by : " + OutOfMemoryObserver.getFirstOOMStack();
        }
        return "no oom";
    }

    @Override
    public boolean $configEnable() {
        return this.config.isEnable();
    }

    @Override
    public IndicatorItemConfig getIndicatorConfig() {
        return this.config;
    }

    @Override
    public List<Action> actionsWhenExceptions() {
        ArrayList<Action> ls = new ArrayList<Action>(2);
        int leve = this.getHealthLevel().getLevel();
        ls.add(ActionFactory.getExcutor("pause").withParam(new ActionParam().withIndicator(this.getName()).withDesc(this.getHealthDetail()).withLevel(leve)));
        ls.add(ActionFactory.getExcutor("dump").withParam(new ActionParam().withIndicator(this.getName()).withDesc(this.getHealthDetail()).withLevel(leve)));
        if (this.config.autoRestart) {
            ls.add(ActionFactory.getExcutor("restart").withParam(new ActionParam().withIndicator(this.getName()).withDesc(this.getHealthDetail()).withWaitSeconds(this.config.restartAfterSeconds).withLevel(leve)));
        }
        return ls;
    }

    @Override
    public Set<String> getAssistDiagnoseType() {
        HashSet<String> s = new HashSet<String>(2);
        s.add("oomstack");
        s.add("stack");
        return s;
    }

    static {
        try {
            String registerMetricKey = "kd.metrics.jvm.oom";
            MetricSystem.registerGauge((String)registerMetricKey, () -> OutOfMemoryObserver.hasOOM() ? 1 : 0);
        }
        catch (Throwable e) {
            ExceptionUtils.parseException((Throwable)e);
        }
    }

    private static class ItemConfig
    extends CommonIndicatorItemConfig {
        private boolean autoRestart = EnvUtils.isRunningInsideContainer();
        private int restartAfterSeconds = 300;

        private ItemConfig() {
        }

        @Override
        public void initFieldMeta() {
            super.initFieldMeta();
            ConfigItemMeta normalMaxValueFiledMeta = new ConfigItemMeta("autoRestart").withDefaultValue(EnvUtils.isRunningInsideContainer()).withDisplayLabelName(new LangSupplier(LangRes.healthmanage, "OOMIndicator_2", "Abnormal auto-restart"));
            this.initInfosMap.put(normalMaxValueFiledMeta.getFiledName(), normalMaxValueFiledMeta);
            ConfigItemMeta busyMaxValueFiledMeta = new ConfigItemMeta("restartAfterSeconds").withDefaultValue(300).withDisplayLabelName(new LangSupplier(LangRes.healthmanage, "OOMIndicator_3", "Restart delay (s)"));
            this.initInfosMap.put(busyMaxValueFiledMeta.getFiledName(), busyMaxValueFiledMeta);
        }
    }
}

