/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.healthmanage.indicator;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.LimitQueue;
import kd.bos.mservice.monitor.healthmanage.config.CommonIndicatorItemConfig;
import kd.bos.mservice.monitor.healthmanage.config.ConfigItemMeta;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorConfigurable;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorItemConfig;
import kd.bos.mservice.monitor.healthmanage.indicator.FullGCStatics;
import kd.bos.mservice.monitor.healthmanage.indicator.PodCpuMonitor;
import kd.bos.mservice.monitor.items.Indicator;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.mservice.monitor.lang.LangSupplier;

public class PodCpuIndicator
implements Indicator,
IndicatorConfigurable {
    private static Log log = LogFactory.getLog(FullGCStatics.class);
    private ItemConfig config = new ItemConfig();
    private LimitQueue<Double> cacheStatus = new LimitQueue(10);
    private int maxLogCount = 0;

    @Override
    public IndicatorItemConfig getIndicatorConfig() {
        return this.config;
    }

    @Override
    public HealthLevel getHealthLevel() {
        Double avgIndicator = this.cacheStatus.getLast();
        if (avgIndicator == null) {
            return HealthLevel.NORMAL;
        }
        if (avgIndicator <= this.config.normalMaxValue) {
            return HealthLevel.NORMAL;
        }
        if (avgIndicator <= this.config.busyMaxValue) {
            return HealthLevel.BUSY;
        }
        return HealthLevel.OVERLOAD;
    }

    @Override
    public String getName() {
        return "PodCpu";
    }

    @Override
    public String getDesc() {
        return this.getHealthDetail();
    }

    @Override
    public String getHealthDetail() {
        Double cur = this.cacheStatus.getLast();
        BigDecimal bg = BigDecimal.valueOf(cur).setScale(2, 4);
        return " pod cpu percent: " + bg + "%";
    }

    @Override
    public void touch() {
        try {
            this.cacheStatus.offer(this.getAvgCpuUsage());
        }
        catch (Exception e) {
            log.error("get pod cpu usage error ", (Throwable)e);
        }
    }

    private double getAvgCpuUsage() {
        double indicator;
        block3: {
            indicator = 0.0;
            try {
                indicator = PodCpuMonitor.getPodCpuPercentUsage();
            }
            catch (Exception e) {
                if (this.maxLogCount++ >= 10) break block3;
                log.error("get pod cpuusage error ", (Throwable)e);
            }
        }
        int itemsize = this.cacheStatus.size();
        if (itemsize == 0) {
            return indicator;
        }
        Double preindicators = this.cacheStatus.getLast();
        double avgval = (preindicators * (double)itemsize + indicator) / (double)(itemsize + 1);
        return avgval;
    }

    @Override
    public boolean canResponse() {
        return true;
    }

    @Override
    public boolean isOnlyMservice() {
        return false;
    }

    @Override
    public boolean $configEnable() {
        if (!Boolean.getBoolean("bos.podcpu.enable")) {
            return false;
        }
        return this.config.isEnable();
    }

    @Override
    public Set<String> getAssistDiagnoseType() {
        HashSet<String> s = new HashSet<String>(2);
        s.add("topthread");
        s.add("stack");
        return s;
    }

    private static class ItemConfig
    extends CommonIndicatorItemConfig {
        private double normalMaxValue = 80.0;
        private double busyMaxValue = 95.0;

        private ItemConfig() {
        }

        @Override
        public void initFieldMeta() {
            super.initFieldMeta();
            ConfigItemMeta normalMaxValueFiledMeta = new ConfigItemMeta("normalMaxValue").withDefaultValue(80).withDisplayLabelName(new LangSupplier(LangRes.healthmanage, "ConfigurationIndicator_1", "Normal state maximum percentage threshold (%)"));
            this.initInfosMap.put(normalMaxValueFiledMeta.getFiledName(), normalMaxValueFiledMeta);
            ConfigItemMeta busyMaxValueFiledMeta = new ConfigItemMeta("busyMaxValue").withDefaultValue(95).withDisplayLabelName(new LangSupplier(LangRes.healthmanage, "ConfigurationIndicator_2", "Busy state maximum percentage threshold (%)"));
            this.initInfosMap.put(busyMaxValueFiledMeta.getFiledName(), busyMaxValueFiledMeta);
        }
    }
}

