/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.healthmanage.indicator;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.locks.LockSupport;
import kd.bos.util.EnvUtils;

public class PodCpuMonitor {
    private static String findCgroupPath(String subsystem) {
        return "/sys/fs/cgroup/" + subsystem;
    }

    private static long getCpuUsage() throws Exception {
        String cgroupPath = PodCpuMonitor.findCgroupPath("cpu,cpuacct");
        String cpuAcctUsagePath = cgroupPath + (cgroupPath.contains("cpu,cpuacct") ? "/cpuacct.usage" : "/cpu.stat");
        try (BufferedReader br = new BufferedReader(new FileReader(cpuAcctUsagePath));){
            long l = Long.parseLong(br.readLine().trim());
            return l;
        }
    }

    protected static double getPodCpuPercentUsage() throws Exception {
        if (!EnvUtils.isRunningInsideContainer()) {
            return 0.0;
        }
        double cpuQuota = PodCpuMonitor.getCpuQuota();
        long prevUsage = PodCpuMonitor.getCpuUsage();
        long prevTime = System.nanoTime();
        LockSupport.parkNanos(100L);
        long currUsage = PodCpuMonitor.getCpuUsage();
        long currTime = System.nanoTime();
        double deltaUsage = currUsage - prevUsage;
        double deltaTime = currTime - prevTime;
        double cpuUsagePercent = deltaUsage / deltaTime / cpuQuota * 100.0;
        return cpuUsagePercent;
    }

    private static double getCpuQuota() {
        String cgroupPath = PodCpuMonitor.findCgroupPath("cpu,cpuacct");
        long quota = PodCpuMonitor.readLongFromFile(cgroupPath + "/cpu.cfs_quota_us");
        long period = PodCpuMonitor.readLongFromFile(cgroupPath + "/cpu.cfs_period_us");
        System.out.println("cpu quota:" + quota);
        if (quota == -1L) {
            return Runtime.getRuntime().availableProcessors();
        }
        return (double)quota / (double)period;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long readLongFromFile(String path) {
        try (BufferedReader br = new BufferedReader(new FileReader(path));){
            long l = Long.parseLong(br.readLine().trim());
            return l;
        }
        catch (IOException | NumberFormatException e) {
            return -1L;
        }
    }
}

