/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.healthmanage.inspect;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.healthmanage.config.ConfigItemMeta;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorConfig;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorConfigurable;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorItemConfig;
import kd.bos.mservice.monitor.healthmanage.indicator.IndicatorChain;
import kd.bos.mservice.monitor.healthmanage.indicator.IndicatorValInfo;
import kd.bos.mservice.monitor.items.Indicator;

public class IndicatorsInspect {
    private static Log log = LogFactory.getLog(IndicatorsInspect.class);

    public static List<IndicatorValInfo> getAllHelathIndicators() {
        ArrayList<IndicatorValInfo> indicators = new ArrayList<IndicatorValInfo>(4);
        for (Map.Entry<String, Indicator> entry : IndicatorChain.getInstance().getIndicators().entrySet()) {
            Indicator v = entry.getValue();
            if (!v.isEnable()) continue;
            int healthlevel = 10;
            String detail = null;
            try {
                healthlevel = v.getHealthLevel().getLevel();
            }
            catch (Exception e) {
                detail = "featch " + v.getName() + " incidator level error!" + e;
                log.error(detail, (Throwable)e);
            }
            try {
                detail = v.getHealthDetail();
            }
            catch (Exception e) {
                detail = "featch " + v.getName() + " incidator detail error!" + e;
                log.error(detail, (Throwable)e);
            }
            IndicatorValInfo indicatorVal = new IndicatorValInfo(v.getName(), healthlevel);
            indicatorVal.setHealthDetail(detail);
            indicators.add(indicatorVal);
        }
        return indicators;
    }

    public static Map<String, Map<String, ConfigItemMeta>> getConfigableIndicatorMeta() {
        HashMap<String, Map<String, ConfigItemMeta>> indicators = new HashMap<String, Map<String, ConfigItemMeta>>(4);
        for (Map.Entry<String, Indicator> entry : IndicatorChain.getInstance().getAllIndicators().entrySet()) {
            Indicator v = entry.getValue();
            if (IndicatorConfig.isDisable(v.getName()) || !(v instanceof IndicatorConfigurable)) continue;
            IndicatorConfigurable ivc = (IndicatorConfigurable)((Object)v);
            IndicatorItemConfig itemConfig = ivc.getIndicatorConfig();
            Map<String, ConfigItemMeta> fieldMetas = itemConfig.getConfigItemMap();
            indicators.put(v.getName(), fieldMetas);
            if (itemConfig.hasInitedFieldMeta()) continue;
            itemConfig.initFieldMeta();
            Field[] fields = itemConfig.getClass().getDeclaredFields();
            HashSet<Field> fset = new HashSet<Field>(4);
            for (Field field : fields) {
                fset.add(field);
            }
            Class<?> superClass = itemConfig.getClass().getSuperclass();
            if (superClass != null) {
                for (Field field : fields = superClass.getDeclaredFields()) {
                    fset.add(field);
                }
            }
            for (Field field : fset) {
                ConfigItemMeta fieldMeta = fieldMetas.get(field.getName());
                if (fieldMeta == null) continue;
                fieldMeta.setType(field.getType());
            }
        }
        return indicators;
    }

    public static Map<String, String> getIndicatorDesc() {
        HashMap<String, String> indicators = new HashMap<String, String>(4);
        for (Map.Entry<String, Indicator> entry : IndicatorChain.getInstance().getIndicators().entrySet()) {
            Indicator v = entry.getValue();
            if (IndicatorConfig.isDisable(v.getName())) continue;
            indicators.put(v.getName(), v.getDesc());
        }
        return indicators;
    }
}

