/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.healthmanage.inspect;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.metric.MetricSystem;
import kd.bos.mservice.monitor.healthmanage.cluster.ClusterHealth;
import kd.bos.mservice.monitor.healthmanage.inspect.InvokeStatistics;
import kd.bos.mservice.monitor.healthmanage.inspect.InvokeStatisticsFactory;
import kd.bos.mservice.monitor.healthmanage.inspect.StatisticsInfo;
import kd.bos.mservice.monitor.healthmanage.node.NodeHealth;

public class TpsMetric {
    public static final String NODETPS = "nodetps";
    public static final String NODEHEALTH = "nodehealth";
    private static TpsMetric instance = new TpsMetric();
    private Map<String, String> statisticsMap = new ConcurrentHashMap<String, String>(2);
    private Map<String, Set<String>> metricKeys = new ConcurrentHashMap<String, Set<String>>(2);

    public static TpsMetric getInstance() {
        return instance;
    }

    private TpsMetric() {
    }

    public void init() {
        MetricSystem.registerGauge((String)"kd.metrics.mservice.nodehealth", () -> NodeHealth.getNodeHealth().getLevel());
    }

    public void touchLastStatistics() {
        Collection<InvokeStatistics> staticticsColl = InvokeStatisticsFactory.getAllStatistics();
        staticticsColl.forEach(v -> {
            String staticticsName = v.getName();
            Set metricKeySet = this.metricKeys.computeIfAbsent(staticticsName, k -> new HashSet(2));
            List<StatisticsInfo> sinfoLs = v.statistics();
            for (StatisticsInfo sinfo : sinfoLs) {
                this.statisticsMap.computeIfAbsent(staticticsName + "--" + sinfo.getInstanceid(), k -> {
                    String registerMetricKey = "kd.metrics.mservice.nodetps." + staticticsName + "--" + sinfo.getInstanceid();
                    metricKeySet.add(registerMetricKey);
                    MetricSystem.registerGauge((String)registerMetricKey, () -> v.getTps(sinfo.getInstanceid()));
                    String nodeHealthMetricKey = "kd.metrics.mservice.nodeChealth." + staticticsName + "--" + sinfo.getInstanceid();
                    MetricSystem.registerGauge((String)nodeHealthMetricKey, () -> ClusterHealth.getHealth(sinfo.getInstanceid()));
                    return "";
                });
            }
        });
    }

    public Set<String> getAllMetricKeys(String type) {
        return this.metricKeys.get(type);
    }
}

