/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.healthmanage.node;

import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.memory.StatusChecker;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.MserviceStatus;
import kd.bos.mservice.monitor.MserviceStatusManger;
import kd.bos.mservice.monitor.action.NodeAction;
import kd.bos.mservice.monitor.healthmanage.cluster.ClusterNotifyHealthFactory;
import kd.bos.mservice.monitor.healthmanage.config.HealthConfig;
import kd.bos.mservice.monitor.healthmanage.indicator.IndicatorChain;
import kd.bos.mservice.monitor.healthmanage.indicator.WorstIndicatorInfo;
import kd.bos.mservice.monitor.healthmanage.inspect.TpsMetric;
import kd.bos.mservice.monitor.items.Indicator;
import kd.bos.mservice.monitor.report.HealthReporter;
import kd.bos.mservice.monitor.report.UnhealthInfomationCollector;

public class NodeHealth {
    private static final String SERVICE_HEALTH_OF_NODE = "node.health.value";
    private static Log log = LogFactory.getLog(NodeHealth.class);
    private static AtomicBoolean isinited = new AtomicBoolean(false);
    private static AtomicBoolean hasRecordError = new AtomicBoolean(false);

    public static void init() {
        if (isinited.compareAndSet(false, true)) {
            try {
                Timer timer = new Timer("HealthStatus-Daemon", true);
                final AtomicLong x = new AtomicLong(0L);
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            if (x.incrementAndGet() % 2L == 0L) {
                                IndicatorChain.getInstance().touch();
                                MserviceStatus ms = MserviceStatusManger.createMserviceStatus();
                                WorstIndicatorInfo worst = ms.getNodeHealthLevel();
                                if (worst.getLevel() > HealthLevel.NORMAL.getLevel()) {
                                    System.setProperty(NodeHealth.SERVICE_HEALTH_OF_NODE, worst.toString());
                                } else {
                                    System.setProperty(NodeHealth.SERVICE_HEALTH_OF_NODE, "normal");
                                }
                            }
                        }
                        catch (Exception e) {
                            log.warn("NodeHealth-Daemon touch", (Throwable)e);
                        }
                        try {
                            if (x.get() % (long)HealthConfig.getBroadcastNotifyInterval() == 0L) {
                                Set<String> healthErrorSet;
                                WorstIndicatorInfo nodehelath;
                                int nodeLevel;
                                if (Boolean.getBoolean("memory.checker.enable")) {
                                    StatusChecker.check();
                                }
                                if ((nodeLevel = (nodehelath = NodeHealth.getNodeHealth()).getLevel()) == HealthLevel.ERROR.getLevel()) {
                                    if (!hasRecordError.get()) {
                                        hasRecordError.set(true);
                                        log.warn("nodehealthwarn:" + nodehelath.toString());
                                    } else if (x.get() % (long)(HealthConfig.getBroadcastNotifyInterval() * 24) > 0L) {
                                        log.warn("nodehealthwarn:" + nodehelath.toString());
                                    }
                                } else if (nodehelath.getDes() != null) {
                                    log.warn("nodehealthwarn:" + nodehelath.toString());
                                }
                                ClusterNotifyHealthFactory.getNotifyer().broadcastHealth(nodehelath);
                                ClusterNotifyHealthFactory.getNotifyer().receiveHealth();
                                TpsMetric.getInstance().touchLastStatistics();
                                HealthReporter.getInstance().report();
                                Set<String> unhealthSet = nodehelath.getUnHealthIndicators();
                                if (unhealthSet.size() > 0) {
                                    UnhealthInfomationCollector.notifyCollect(unhealthSet);
                                    if (unhealthSet.contains("memory")) {
                                        NodeAction.performFullGc();
                                    }
                                }
                                if ((healthErrorSet = nodehelath.getErrorIndicators()).size() > 0) {
                                    NodeAction.notifyAction(healthErrorSet);
                                }
                            }
                        }
                        catch (Exception e) {
                            log.warn("NodeHealth-Daemon notify", (Throwable)e);
                        }
                    }
                }, 6000L, 1000L);
                TpsMetric.getInstance().init();
                HealthReporter.getInstance().init();
            }
            catch (Throwable e) {
                log.error("init  exception", e);
            }
        }
    }

    public static WorstIndicatorInfo getNodeHealth() {
        String name = "all";
        int level = HealthLevel.INITIAL.getLevel();
        String des = null;
        WorstIndicatorInfo info = new WorstIndicatorInfo();
        for (Map.Entry<String, Indicator> entry : IndicatorChain.getInstance().getIndicators().entrySet()) {
            int vlevel;
            String k = entry.getKey();
            Indicator v = entry.getValue();
            if (!v.isEnable() || (vlevel = v.getHealthLevel().getLevel()) < level) continue;
            name = k;
            level = vlevel;
            if (level > HealthLevel.NORMAL.getLevel()) {
                des = v.getHealthDetail();
            }
            if (level > HealthLevel.BUSY.getLevel()) {
                info.addUnHealthIndicator(name);
            }
            if (level != HealthLevel.ERROR.getLevel()) continue;
            info.addErrorIndicator(name);
        }
        info.setName(name);
        info.setLevel(level);
        info.setDes(des);
        return info;
    }

    public static boolean canResponse() {
        for (Map.Entry<String, Indicator> entry : IndicatorChain.getInstance().getIndicators().entrySet()) {
            Indicator indicator = entry.getValue();
            if (!indicator.isEnable() || indicator.canResponse() && HealthLevel.ERROR != indicator.getHealthLevel()) continue;
            log.error("node canResponse is false , " + indicator.getName() + ":" + indicator.getHealthDetail());
            return false;
        }
        return true;
    }
}

