/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.query;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import kd.bos.govern.SearcherCondition;
import kd.bos.govern.StorageSearcherRegister;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.mservice.monitor.query.AppUnhealthDetail;
import kd.bos.mservice.monitor.query.AppUnhealthHead;
import kd.bos.mservice.monitor.query.HealthAssistDiagnoseData;
import kd.bos.mservice.monitor.query.HistoryAppHealthData;
import kd.bos.mservice.monitor.query.NodehealthDetailInfo;
import kd.bos.mservice.monitor.query.TotalAppHealthData;
import kd.bos.mservice.monitor.report.pojo.LoadTpsPojo;
import kd.bos.mservice.monitor.report.pojo.NodeHealthPojo;
import kd.bos.mservice.monitor.report.pojo.UnhealthAssistDiagnosePojo;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class HealthQueryImpl {
    protected JSONObject queryHistoryTps(String appName, Date from, Date to, int maxSize) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"appName.keyword", (String)appName));
        JSONObject ret = new JSONObject();
        Consumer consumer = (Consumer<List> & Serializable)datas -> {
            if (datas.isEmpty()) {
                return;
            }
            datas.forEach(v -> {
                String key = (String)v.get("instanceId");
                if (ret.containsKey((Object)key)) {
                    this.seriesTPS((Map<String, String>)v, ret.getJSONObject(key));
                } else {
                    JSONObject data = new JSONObject();
                    this.seriesTPS((Map<String, String>)v, data);
                    ret.put(key, (Object)data);
                }
            });
        };
        SearcherCondition condition = new SearcherCondition();
        condition.withFrom(from).withTo(to).withIndexPre(LoadTpsPojo.indexPrefix).withFields(new String[]{"*"}).withWhere((QueryBuilder)boolQueryBuilder).withOrderby("timestamp:asc").withBatch(1000).withConsumer(consumer).withMaxSize(maxSize);
        StorageSearcherRegister.queryByScroll((SearcherCondition)condition);
        return ret;
    }

    private void seriesTPS(Map<String, String> v, JSONObject jsonObject) {
        JSONArray xAxis = jsonObject.getJSONArray("xAxis");
        if (xAxis == null) {
            xAxis = new JSONArray();
            jsonObject.put("xAxis", (Object)xAxis);
        }
        xAxis.add((Object)v.get("xAxis"));
        JSONArray tempXAxis = xAxis;
        v.forEach((key, value) -> {
            if (key.startsWith("outtps.rpc.")) {
                String destInstanceId = key.substring("outtps.rpc.".length());
                JSONArray destInstanceArray = jsonObject.getJSONArray(destInstanceId);
                if (destInstanceArray == null) {
                    destInstanceArray = new JSONArray();
                    for (int i = 0; i < tempXAxis.size() - 1; ++i) {
                        destInstanceArray.add(null);
                    }
                    jsonObject.put(destInstanceId, (Object)destInstanceArray);
                }
                destInstanceArray.add(value);
            }
        });
    }

    protected Map<String, TotalAppHealthData> queryHistoryApplicationHealth(Date from, Date to, int maxSize) {
        if (to == null) {
            to = new Date();
        } else if (to.getTime() > System.currentTimeMillis()) {
            to.setTime(System.currentTimeMillis());
        }
        Date _to = to;
        HashMap<String, TotalAppHealthData> ret = new HashMap<String, TotalAppHealthData>(4);
        Consumer consumer = (Consumer<List> & Serializable)datas -> {
            if (datas.isEmpty()) {
                return;
            }
            datas.forEach(data -> {
                String appName = (String)data.get("appName");
                TotalAppHealthData tahd = ret.computeIfAbsent(appName, k -> {
                    TotalAppHealthData newtahd = new TotalAppHealthData(appName);
                    newtahd.initHistoryAppHealthDatas(from, _to);
                    return newtahd;
                });
                HistoryAppHealthData hahd = tahd.getHistoryAppHealthData(Long.parseLong((String)data.get("timestamp")));
                if (hahd != null) {
                    hahd.setHealthLevel((String)data.get("instanceId"), (String)data.get("nodeHealthLevel"));
                }
            });
        };
        SearcherCondition condition = new SearcherCondition();
        condition.withFrom(from).withTo(to).withIndexPre(NodeHealthPojo.indexPrefix).withFields(new String[]{"appName", "timestamp", "nodeHealthLevel", "instanceId"}).withWhere(null).withOrderby(null).withBatch(1000).withConsumer(consumer).withMaxSize(maxSize * maxSize);
        StorageSearcherRegister.queryByScroll((SearcherCondition)condition);
        return ret;
    }

    protected List<NodehealthDetailInfo> queryHistoryUnhealthDetail(String appName, String instanceid, Date from, Date to, boolean includeNormal, int maxSize) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (includeNormal) {
            if (instanceid == null || instanceid.length() == 0) {
                throw new RuntimeException("must query a instance for all health");
            }
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"nodeHealthLevel").gte((Object)HealthLevel.INITIAL.getLevel()));
        } else {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"nodeHealthLevel").gte((Object)HealthLevel.OVERLOAD.getLevel()));
        }
        if (instanceid != null && instanceid.length() > 0) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"instanceId.keyword", (String)instanceid));
        } else if (appName != null && appName.length() > 0) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"appName.keyword", (String)appName));
        }
        ArrayList<NodehealthDetailInfo> ret = new ArrayList<NodehealthDetailInfo>(2);
        Consumer consumer = (Consumer<List> & Serializable)datas -> {
            if (datas.isEmpty()) {
                return;
            }
            datas.forEach(v -> {
                NodehealthDetailInfo ndi = new NodehealthDetailInfo();
                ret.add(ndi);
                ndi.setInstanceId((String)v.get("instanceId"));
                ndi.setAppName((String)v.get("appName"));
                ndi.setxAxis((String)v.get("xAxis"));
                ndi.setTimestamp((String)v.get("timestamp"));
                ndi.setNodeHealthLevel(Integer.parseInt((String)v.get("nodeHealthLevel")));
                if (!ndi.isHealth()) {
                    String levelpre = "indicator.level.";
                    String levelDesc = "indicator.desc.";
                    v.forEach((key, vvalue) -> {
                        if (key.startsWith(levelpre)) {
                            ndi.setUnhealthIndicatorLevel(key.substring(levelpre.length()), Integer.parseInt(vvalue));
                        }
                        if (key.startsWith(levelDesc)) {
                            ndi.setUnhealthIndicatorDesc(key.substring(levelDesc.length()), (String)vvalue);
                        }
                    });
                }
            });
        };
        SearcherCondition condition = new SearcherCondition();
        condition.withFrom(from).withTo(to).withIndexPre(NodeHealthPojo.indexPrefix).withFields(new String[]{"*"}).withWhere((QueryBuilder)boolQueryBuilder).withOrderby("timestamp:desc").withBatch(1000).withConsumer(consumer).withMaxSize(maxSize);
        StorageSearcherRegister.queryByScroll((SearcherCondition)condition);
        Collections.sort(ret, new Comparator<NodehealthDetailInfo>(){

            @Override
            public int compare(NodehealthDetailInfo o1, NodehealthDetailInfo o2) {
                return (int)(Long.parseLong(o2.getTimestamp()) - Long.parseLong(o1.getTimestamp()));
            }
        });
        return ret;
    }

    protected Map<Long, HealthAssistDiagnoseData> queryAssistDiagnose(String instanceId, long timestamp, int maxSize) {
        timestamp = this.queryNearByTimestampOfAssist(instanceId, timestamp);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"instanceId.keyword", (String)instanceId));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"timestamp", (long)timestamp));
        HashMap<Long, HealthAssistDiagnoseData> ret = new HashMap<Long, HealthAssistDiagnoseData>(2);
        Consumer consumer = (Consumer<List> & Serializable)datas -> {
            if (datas.isEmpty()) {
                return;
            }
            datas.forEach(data -> {
                long timestampret = Long.parseLong((String)data.get("timestamp"));
                HealthAssistDiagnoseData hadd = ret.computeIfAbsent(timestampret, k -> new HealthAssistDiagnoseData());
                String appName = (String)data.get("appName");
                hadd.setAppName(appName);
                hadd.setInstanceId((String)data.get("instantId"));
                hadd.setxAxis((String)data.get("xAxis"));
                hadd.setTimestamp(timestampret);
                hadd.addAssistDiagnoseData((String)data.get("assistType"), hadd.getxAxis() + " \n" + (String)data.get("message"));
            });
        };
        SearcherCondition condition = new SearcherCondition();
        condition.withFrom(new Date(timestamp - 60000L)).withTo(new Date(timestamp + 300000L)).withIndexPre(UnhealthAssistDiagnosePojo.indexPrefix).withFields(new String[]{"*"}).withWhere((QueryBuilder)boolQueryBuilder).withOrderby(null).withBatch(1000).withConsumer(consumer).withMaxSize(maxSize);
        StorageSearcherRegister.queryByScroll((SearcherCondition)condition);
        return ret;
    }

    private long queryNearByTimestampOfAssist(String instanceId, long timestamp) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"instanceId.keyword", (String)instanceId));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").gte((Object)timestamp));
        AtomicLong timestap = new AtomicLong(0L);
        Consumer consumer = (Consumer<List> & Serializable)datas -> {
            if (datas.isEmpty()) {
                return;
            }
            if (timestap.get() > 0L) {
                return;
            }
            timestap.set(Long.parseLong((String)((Map)datas.get(0)).get("timestamp")));
        };
        SearcherCondition condition = new SearcherCondition();
        condition.withFrom(new Date(timestamp - 60000L)).withTo(new Date(timestamp + 60000000L)).withIndexPre(UnhealthAssistDiagnosePojo.indexPrefix).withFields(new String[]{"timestamp"}).withWhere((QueryBuilder)boolQueryBuilder).withOrderby("timestamp:asc").withBatch(1000).withConsumer(consumer).withMaxSize(10);
        StorageSearcherRegister.queryByScroll((SearcherCondition)condition);
        if (timestap.get() == 0L) {
            boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"instanceId.keyword", (String)instanceId));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").lte((Object)timestamp));
            condition.withFrom(new Date(timestamp - 600000L)).withTo(new Date(timestamp + 6000L)).withIndexPre(UnhealthAssistDiagnosePojo.indexPrefix).withFields(new String[]{"timestamp"}).withWhere((QueryBuilder)boolQueryBuilder).withOrderby("timestamp:asc").withBatch(1000).withConsumer(consumer).withMaxSize(10);
            StorageSearcherRegister.queryByScroll((SearcherCondition)condition);
        }
        return timestap.get();
    }

    protected List<AppUnhealthHead> queryAppHealthUnhealthInfo(Date from, Date to, int maxSize) {
        ArrayList<AppUnhealthHead> ls = new ArrayList<AppUnhealthHead>(2);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"nodeHealthLevel").gte((Object)HealthLevel.OVERLOAD.getLevel()));
        HashMap mapHeader = new HashMap(2);
        HashMap mapDetail = new HashMap(2);
        Consumer consumer = (Consumer<List> & Serializable)datas -> {
            if (datas.isEmpty()) {
                return;
            }
            datas.forEach(v -> {
                String actions;
                String appName = (String)v.get("appName");
                AppUnhealthHead ahead = mapHeader.computeIfAbsent(appName, k -> {
                    AppUnhealthHead newtahd = new AppUnhealthHead(appName);
                    ls.add(newtahd);
                    return newtahd;
                });
                String healthtrace = (String)v.get("healthtrace");
                String mainIndicator = (String)v.get("worstIndicator");
                boolean isAction = mainIndicator.startsWith("[ACTION]");
                String string = actions = isAction ? mainIndicator.substring("[ACTION]".length()) : null;
                if (healthtrace != null) {
                    int leve;
                    long timestamp;
                    AppUnhealthDetail detail = mapDetail.computeIfAbsent(healthtrace, k -> {
                        AppUnhealthDetail auhd = new AppUnhealthDetail();
                        auhd.setInstanceId((String)v.get("instanceId"));
                        auhd.setBegin((String)v.get("xAxis"));
                        auhd.setBeginTimestamp(Long.parseLong((String)v.get("timestamp")));
                        auhd.setEnd(auhd.getBegin());
                        auhd.setEndTimestamp(auhd.getBeginTimestamp());
                        auhd.setHealthlevel(Integer.parseInt((String)v.get("nodeHealthLevel")));
                        auhd.setIndicatorType(mainIndicator);
                        auhd.setRecoveryType(actions == null ? LangRes.healthmanage.getString("HealthQuery_1", "automatic recovery", new Object[0]) : actions);
                        ahead.addUnhealthDetail(auhd);
                        return auhd;
                    });
                    if (actions != null) {
                        detail.setRecoveryType(detail.getRecoveryType() + "," + actions);
                    }
                    if ((timestamp = Long.parseLong((String)v.get("timestamp"))) > detail.getEndTimestamp()) {
                        detail.setEndTimestamp(timestamp);
                        detail.setEnd((String)v.get("xAxis"));
                    }
                    if (timestamp < detail.getBeginTimestamp()) {
                        detail.setBeginTimestamp(timestamp);
                        detail.setBegin((String)v.get("xAxis"));
                    }
                    if ((leve = Integer.parseInt((String)v.get("nodeHealthLevel"))) > detail.getHealthlevel()) {
                        detail.setHealthlevel(leve);
                        detail.setIndicatorType(mainIndicator);
                    }
                    ahead.setHealthDispatch((int)(detail.getEndTimestamp() - detail.getBeginTimestamp()) % 100);
                }
            });
        };
        SearcherCondition condition = new SearcherCondition();
        condition.withFrom(from).withTo(to).withIndexPre(NodeHealthPojo.indexPrefix).withFields(new String[]{"*"}).withWhere((QueryBuilder)boolQueryBuilder).withOrderby(null).withBatch(1000).withConsumer(consumer).withMaxSize(maxSize);
        StorageSearcherRegister.queryByScroll((SearcherCondition)condition);
        return ls;
    }
}

