/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.query;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.bundle.Resources;
import kd.bos.mservice.monitor.HealthLevel;

public class NodehealthDetailInfo {
    private String instanceId;
    private String appName;
    private String xAxis;
    private int nodeHealthLevel;
    private transient String timestamp;
    private Map<String, UnhealthIndicatorInfo> unhealthIndicators = new ConcurrentHashMap<String, UnhealthIndicatorInfo>(2);
    private Map<String, String> assistDiagnose = new ConcurrentHashMap<String, String>(2);

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getxAxis() {
        return this.xAxis;
    }

    public void setxAxis(String xAxis) {
        this.xAxis = xAxis;
    }

    public int getNodeHealthLevel() {
        return this.nodeHealthLevel;
    }

    public void setNodeHealthLevel(int nodeHealthLevel) {
        this.nodeHealthLevel = nodeHealthLevel;
    }

    public Map<String, UnhealthIndicatorInfo> getUnhealthIndicators() {
        return this.unhealthIndicators;
    }

    public boolean isHealth() {
        return this.nodeHealthLevel < HealthLevel.OVERLOAD.getLevel();
    }

    public void setUnhealthIndicatorLevel(String indictorName, int level) {
        UnhealthIndicatorInfo uii = this.getUnhealthIndicatorInfo(indictorName);
        uii.healthLevel = level;
    }

    public void setUnhealthIndicatorDesc(String indictorName, String desc) {
        UnhealthIndicatorInfo uii = this.getUnhealthIndicatorInfo(indictorName);
        uii.desc = desc;
    }

    private UnhealthIndicatorInfo getUnhealthIndicatorInfo(String indictorName) {
        return this.unhealthIndicators.computeIfAbsent(indictorName, k -> {
            UnhealthIndicatorInfo uii = new UnhealthIndicatorInfo();
            uii.indicatorName = indictorName;
            return uii;
        });
    }

    public Map<String, String> getAssistDiagnose() {
        return this.assistDiagnose;
    }

    public Map<String, String> getFullAssistDiagnoseQueryCondition() {
        HashMap<String, String> queryMoreConditions = new HashMap<String, String>(2);
        queryMoreConditions.put("instanceId", this.instanceId);
        queryMoreConditions.put("xAxis", this.xAxis);
        queryMoreConditions.put("display", Resources.get((String)"bos-healthmanage", (String)"NodehealthDetailInfo_1", (String)"\u66f4\u591a(\u4f7f\u7528\u6761\u4ef6\u518d\u6b21\u67e5\u8be2)", (Object[])new Object[0]));
        queryMoreConditions.put("timestamp", this.timestamp);
        return queryMoreConditions;
    }

    public void setAssistDiagnose(Map<String, String> assistDiagnose) {
        this.assistDiagnose.clear();
        this.assistDiagnose.putAll(assistDiagnose);
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public static class UnhealthIndicatorInfo {
        private String indicatorName;
        private int healthLevel;
        private String desc;

        public String getIndicatorName() {
            return this.indicatorName;
        }

        public int getHealthLevel() {
            return this.healthLevel;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

