/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.govern.ExtensionGovernPoJo;
import kd.bos.govern.GovernConfigs;
import kd.bos.govern.GovernDataType;
import kd.bos.govern.GovernPoJo;
import kd.bos.govern.StorageReporterFactory;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.action.ActionParam;
import kd.bos.mservice.monitor.healthmanage.indicator.IndicatorChain;
import kd.bos.mservice.monitor.healthmanage.inspect.InvokeStatistics;
import kd.bos.mservice.monitor.healthmanage.inspect.InvokeStatisticsFactory;
import kd.bos.mservice.monitor.healthmanage.inspect.StatisticsInfo;
import kd.bos.mservice.monitor.items.Indicator;
import kd.bos.mservice.monitor.report.pojo.LoadTpsPojo;
import kd.bos.mservice.monitor.report.pojo.NodeHealthPojo;

public class HealthReporter {
    public static final String ACTION = "[ACTION]";
    private static final HealthReporter reporter = new HealthReporter();
    private final ArrayBlockingQueue<ExtensionGovernPoJo> healths = new ArrayBlockingQueue(10000);

    public static HealthReporter getInstance() {
        return reporter;
    }

    public void init() {
        Thread reportThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        int size;
                        if ((size = this.healths.size()) == 0) {
                            ExtensionGovernPoJo extensionGovernPoJo = this.healths.take();
                            if (extensionGovernPoJo == null) continue;
                            StorageReporterFactory.getStorageReporter((GovernDataType)GovernDataType.HEALTH_DATA).reporter((GovernPoJo)extensionGovernPoJo);
                            continue;
                        }
                        ArrayList<ExtensionGovernPoJo> governPoJos = new ArrayList<ExtensionGovernPoJo>(size);
                        for (int i = 0; i < size; ++i) {
                            governPoJos.add(this.healths.poll());
                            if (governPoJos.size() > GovernConfigs.getReportBatchSize()) break;
                        }
                        StorageReporterFactory.getStorageReporter((GovernDataType)GovernDataType.HEALTH_DATA).reporter(governPoJos);
                        governPoJos.clear();
                    }
                }
                catch (Exception e) {
                    try {
                        TimeUnit.SECONDS.sleep(3L);
                    }
                    catch (Exception exception) {
                    }
                    continue;
                }
                break;
            }
        }, "nodehealth-report");
        reportThread.setDaemon(true);
        reportThread.start();
    }

    public void report() {
        this.reportHealthLevel();
        this.reportLoadTps();
    }

    private void reportLoadTps() {
        LoadTpsPojo tpsPojo = new LoadTpsPojo();
        Collection<InvokeStatistics> staticticsColl = InvokeStatisticsFactory.getAllStatistics();
        staticticsColl.forEach(v -> {
            String staticticsName = v.getName();
            List<StatisticsInfo> sinfoLs = v.statistics();
            for (StatisticsInfo sinfo : sinfoLs) {
                tpsPojo.putloadTps(staticticsName, sinfo.getInstanceid(), sinfo.getTps());
            }
        });
        if (!tpsPojo.isEmpty()) {
            this.healths.offer(tpsPojo);
        }
    }

    private void reportHealthLevel() {
        NodeHealthPojo pojo = new NodeHealthPojo();
        int level = HealthLevel.NORMAL.getLevel();
        String name = "all";
        for (Map.Entry<String, Indicator> entry : IndicatorChain.getInstance().getIndicators().entrySet()) {
            int vlevel;
            String k = entry.getKey();
            Indicator v = entry.getValue();
            if (!v.isEnable() || (vlevel = v.getHealthLevel().getLevel()) < level) continue;
            name = k;
            level = vlevel;
            if (level <= HealthLevel.NORMAL.getLevel()) continue;
            pojo.setIndicatorLevel(k, vlevel);
            pojo.setIndicatorDesc(name, v.getHealthDetail());
            pojo.withNodeWorstIndicator(name);
        }
        pojo.withNodeHeathLevel(level);
        this.healths.offer(pojo);
    }

    public void reportAction(String action, ActionParam param) {
        NodeHealthPojo pojo = new NodeHealthPojo();
        int level = param.getLevel();
        pojo.setIndicatorLevel(ACTION, level);
        pojo.setIndicatorDesc(ACTION, "Will auto " + action + " becasue of " + param.getIndicator() + " is " + (Object)((Object)HealthLevel.from(level)));
        pojo.withNodeWorstIndicator(ACTION + action);
        pojo.withNodeHeathLevel(level);
        this.healths.offer(pojo);
    }
}

