/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.report;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.govern.GovernDataType;
import kd.bos.govern.GovernPoJo;
import kd.bos.govern.StorageReporterFactory;
import kd.bos.mservice.monitor.assistant.AssistDiagnose;
import kd.bos.mservice.monitor.assistant.AssistDiagnoseFactory;
import kd.bos.mservice.monitor.healthmanage.indicator.IndicatorChain;
import kd.bos.mservice.monitor.items.Indicator;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.mservice.monitor.report.pojo.UnhealthAssistDiagnosePojo;
import kd.bos.util.SafeLogUtils;

public class UnhealthInfomationCollector {
    private static ArrayBlockingQueue<AssistDiagnoseCollectInfo> healths = new ArrayBlockingQueue(10000);

    public static void notifyCollect(Set<String> indicators) {
        Map<String, Indicator> indicatorsMap = IndicatorChain.getInstance().getIndicators();
        HashSet allDiagnoseType = new HashSet(2);
        indicators.forEach(indicatorName -> {
            Indicator indicator = (Indicator)indicatorsMap.get(indicatorName);
            allDiagnoseType.addAll(indicator.getAssistDiagnoseType());
        });
        boolean isOffered = healths.offer(new AssistDiagnoseCollectInfo(System.currentTimeMillis(), allDiagnoseType));
        if (!isOffered) {
            SafeLogUtils.info(UnhealthInfomationCollector.class, (String)"UnhealthInfomationCollector block queue not offer ");
        }
    }

    private static void collect(AssistDiagnoseCollectInfo poll) {
        Set<String> diagnoseType = poll.getDiagnoseType();
        diagnoseType.forEach(dtype -> {
            AssistDiagnose<?> ad = AssistDiagnoseFactory.getType(dtype);
            if (ad.requireOutPermit()) {
                String assistMessage = (String)ad.getAssistantInfo();
                UnhealthAssistDiagnosePojo pojo = new UnhealthAssistDiagnosePojo();
                pojo.withTimestamp(poll.timestamp).withAssistType((String)dtype).setMessage(assistMessage != null && assistMessage.length() > 0 ? assistMessage : LangRes.healthmanage.getString("UnhealthInfomationCollector_1", "No valid information collected", new Object[0]));
                StorageReporterFactory.getStorageReporter((GovernDataType)GovernDataType.HEALTH_DATA).reporter((GovernPoJo)pojo);
            }
        });
    }

    private static void merge(AssistDiagnoseCollectInfo poll, AssistDiagnoseCollectInfo next) {
        poll.diagnoseType.addAll(next.diagnoseType);
    }

    static {
        Thread reportThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        AssistDiagnoseCollectInfo poll;
                        if ((poll = healths.poll(9000L, TimeUnit.MILLISECONDS)) == null) {
                            continue;
                        }
                        AssistDiagnoseCollectInfo next = healths.peek();
                        while (next != null && (System.currentTimeMillis() - next.timestamp > 5000L || next.timestamp - poll.timestamp < 3000L)) {
                            healths.poll();
                            UnhealthInfomationCollector.merge(poll, next);
                            next = healths.peek();
                        }
                        UnhealthInfomationCollector.collect(poll);
                    }
                }
                catch (Exception e) {
                    try {
                        SafeLogUtils.error(UnhealthInfomationCollector.class, (String)"report AssistDiagnose error", (Throwable)e);
                        TimeUnit.SECONDS.sleep(3L);
                    }
                    catch (Exception exception) {
                    }
                    continue;
                }
                break;
            }
        }, "UnhealthInfomationCollector");
        reportThread.setDaemon(true);
        reportThread.start();
    }

    static class AssistDiagnoseCollectInfo {
        private long timestamp;
        private Set<String> diagnoseType;

        private AssistDiagnoseCollectInfo(long timestamp, Set<String> allDiagnoseType) {
            this.timestamp = timestamp;
            this.diagnoseType = allDiagnoseType;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public Set<String> getDiagnoseType() {
            return this.diagnoseType;
        }
    }
}

