/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.circuitbreaker;

import kd.bos.extension.ExtensionFactory;
import kd.bos.mservice.circuitbreaker.noop.NoopCircuitbreaker;
import kd.bos.mservice.spi.circuitbreaker.Circuitbreaker;

public class CircuitbreakerFactory {
    public static final String CIRCUITBREAKERTYPE = "circuitbreaker.type";
    private static final NoopCircuitbreaker noop = new NoopCircuitbreaker();
    private static final ExtensionFactory<Circuitbreaker> factory = ExtensionFactory.getExtensionFacotry(Circuitbreaker.class);

    public static Circuitbreaker get() {
        if (!Boolean.getBoolean("gov.breaker.enable")) {
            return null;
        }
        String type = CircuitbreakerFactory.getType();
        if (type == null || type.equals("")) {
            return null;
        }
        return (Circuitbreaker)factory.getExtension(type, false);
    }

    public static Circuitbreaker get(String content) {
        try {
            Circuitbreaker c = CircuitbreakerFactory.get();
            if (c == null) {
                return noop;
            }
            c.setContent(content);
            return c;
        }
        catch (Exception e) {
            return noop;
        }
    }

    public static Circuitbreaker get(String content, String appId) {
        return CircuitbreakerFactory.get(content, "default", appId);
    }

    public static Circuitbreaker get(String content, String tenantId, String appId) {
        try {
            Circuitbreaker c = CircuitbreakerFactory.get();
            if (c == null) {
                return noop;
            }
            c.setContent(content, tenantId, appId);
            return c;
        }
        catch (Exception e) {
            return noop;
        }
    }

    private static String getType() {
        return System.getProperty(CIRCUITBREAKERTYPE, "armor");
    }
}

