/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.discovery;

import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.AppGroup;
import kd.bos.instance.Instance;
import kd.bos.mservice.MServiceErrorCode;
import kd.bos.mservice.common.rpc.RegisterAppNameUtils;
import kd.bos.mservice.config.MserviceAssemblyConfig;
import kd.bos.mservice.discovery.KRegistryInstance;
import kd.bos.mservice.spi.define.MServiceDefineMeta;
import kd.bos.util.AppUtils;
import kd.bos.util.StringUtils;

public class KRegistryInstanceCatalog {
    private static final String RPC_TYPE = MserviceAssemblyConfig.MSERVICE_RPC_TYPE;
    private static final Set<String> SERVICENAME_REGISTED_SET = new HashSet<String>(128);
    private static final Map<String, Set<KRegistryInstance>> HTTP_GROUP_REGISTRYINSTANCES_MAP = new HashMap<String, Set<KRegistryInstance>>(32);
    private static final Map<String, Set<KRegistryInstance>> RPC_GROUP_REGISTRYINSTANCES_MAP = new HashMap<String, Set<KRegistryInstance>>(32);
    private static final Map<String, MServiceDefineMeta> INTERFACE_DEFINEMETA_MAP = new ConcurrentHashMap<String, MServiceDefineMeta>();
    private static final Set<String> appIdSet = new HashSet<String>(2);
    public static final String DEFAULT_SYSSERVICE_GROUP = "_sys";

    public static void registerDefineMeta(MServiceDefineMeta mServiceDefineMeta) {
        INTERFACE_DEFINEMETA_MAP.putIfAbsent(mServiceDefineMeta.getServiceName(), mServiceDefineMeta);
    }

    public static void registerService(String name, String config, String transType) {
        if (name.endsWith(".service")) {
            name = name.substring(0, name.indexOf(".service"));
        }
        Properties p = new Properties();
        try {
            p.load(new StringReader(config));
            String interfaceClass = (String)p.get("interface");
            MServiceDefineMeta mServiceDefineMeta = INTERFACE_DEFINEMETA_MAP.get(name);
            if (mServiceDefineMeta != null) {
                if (!mServiceDefineMeta.getTransProtocolTypes().contains(transType)) {
                    mServiceDefineMeta.addTransProtocolTypes(transType);
                }
                KRegistryInstanceCatalog.registerService(mServiceDefineMeta);
                return;
            }
            String interfaceImplClass = (String)p.get("class");
            Set<String> appIdSet = KRegistryInstanceCatalog.getAppIds(p);
            String group = (String)p.get("group");
            group = group == null ? DEFAULT_SYSSERVICE_GROUP : group;
            mServiceDefineMeta = MServiceDefineMeta.of((String)name, (String)group, (String)interfaceClass, (String)interfaceImplClass, (String[])new String[]{transType}, (String[])new String[]{"javaobj"}, (String[])appIdSet.toArray(new String[appIdSet.size()]), (String)"");
            if (mServiceDefineMeta == null) {
                throw new KDException(BosErrorCode.bOS, new Object[]{"cant load mservice for " + interfaceClass + ":" + interfaceImplClass});
            }
            INTERFACE_DEFINEMETA_MAP.putIfAbsent(mServiceDefineMeta.getServiceName(), mServiceDefineMeta);
            KRegistryInstanceCatalog.registerService(mServiceDefineMeta);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{"registerService error:" + name + ",config is " + config});
        }
    }

    private static void registerService(MServiceDefineMeta mServiceDefineMeta) {
        KRegistryInstanceCatalog.prehandleDefineMeta(mServiceDefineMeta);
        if (RPC_TYPE.equals("dubbo")) {
            KRegistryInstanceCatalog.dubboRegisterService(mServiceDefineMeta);
        } else if (RPC_TYPE.equals("feign")) {
            KRegistryInstanceCatalog.feignRegisterService(mServiceDefineMeta, true);
        } else if (RPC_TYPE.equals("assembly")) {
            KRegistryInstanceCatalog.dubboRegisterService(mServiceDefineMeta);
            KRegistryInstanceCatalog.feignRegisterService(mServiceDefineMeta, false);
        }
    }

    private static void prehandleDefineMeta(MServiceDefineMeta mServiceDefineMeta) {
        String[] defineAppIds = mServiceDefineMeta.getAppIds();
        if (defineAppIds != null && defineAppIds.length == 1 && defineAppIds[0].equals("*")) {
            mServiceDefineMeta.setAppIds(appIdSet.toArray(new String[appIdSet.size()]));
        }
    }

    private static void dubboRegisterService(MServiceDefineMeta mServiceDefineMeta) {
        String transType = "rpc";
        if (!mServiceDefineMeta.getTransProtocolTypes().contains("rpc")) {
            return;
        }
        KRegistryInstanceCatalog.registerAppId(transType, mServiceDefineMeta);
    }

    private static void feignRegisterService(MServiceDefineMeta mServiceDefineMeta, boolean bothHttpAndRpc) {
        String transType = "http";
        if (Boolean.getBoolean("mservice.feign.register.withappname")) {
            if (HTTP_GROUP_REGISTRYINSTANCES_MAP.size() > 0) {
                return;
            }
            KRegistryInstance registryInstanceSingleton = KRegistryInstanceCatalog.parseBaseRegistryInstance(transType, mServiceDefineMeta);
            registryInstanceSingleton.setInterfaceClass("");
            HTTP_GROUP_REGISTRYINSTANCES_MAP.putIfAbsent(mServiceDefineMeta.getGroup(), Collections.singleton(registryInstanceSingleton));
            return;
        }
        if (bothHttpAndRpc || mServiceDefineMeta.getTransProtocolTypes().contains("http")) {
            KRegistryInstanceCatalog.registerAppId(transType, mServiceDefineMeta);
        }
    }

    public static Map<String, Set<KRegistryInstance>> getRegistryInstanceMap(String transType) {
        if (transType.equals("http")) {
            return HTTP_GROUP_REGISTRYINSTANCES_MAP;
        }
        return RPC_GROUP_REGISTRYINSTANCES_MAP;
    }

    private static void registerAppId(String transType, MServiceDefineMeta mServiceDefineMeta) {
        String serviceName = mServiceDefineMeta.getServiceName();
        if (!SERVICENAME_REGISTED_SET.add(serviceName + transType)) {
            return;
        }
        KRegistryInstance baseRegistryInstance = KRegistryInstanceCatalog.parseBaseRegistryInstance(transType, mServiceDefineMeta);
        String[] defineAppIds = mServiceDefineMeta.getAppIds();
        if (defineAppIds == null || defineAppIds.length == 0) {
            Set<KRegistryInstance> registryInstanceSet = KRegistryInstanceCatalog.getRegistryInstanceMap(transType).get(baseRegistryInstance.getGroup());
            if (registryInstanceSet == null) {
                registryInstanceSet = new CopyOnWriteArraySet<KRegistryInstance>();
                KRegistryInstanceCatalog.getRegistryInstanceMap(transType).putIfAbsent(baseRegistryInstance.getGroup(), registryInstanceSet);
            }
            registryInstanceSet.add(baseRegistryInstance);
            return;
        }
        for (String tempAppId : defineAppIds) {
            KRegistryInstance newRegistryInstance = null;
            try {
                newRegistryInstance = baseRegistryInstance.clone();
                newRegistryInstance.setRegistryAppName(KRegistryInstanceCatalog.getRegisterAppName(tempAppId, mServiceDefineMeta.getServiceInterface())).setAppGroup(AppGroup.getRegistyAppGroup((String)tempAppId)).setAppId(tempAppId);
            }
            catch (CloneNotSupportedException e) {
                throw new KDException(MServiceErrorCode.serviceNotDefineAppID, new Object[]{e});
            }
            if (newRegistryInstance == null) continue;
            Set<KRegistryInstance> registryInstanceSet = KRegistryInstanceCatalog.getRegistryInstanceMap(transType).get(newRegistryInstance.getGroup());
            if (registryInstanceSet == null) {
                registryInstanceSet = new CopyOnWriteArraySet<KRegistryInstance>();
                KRegistryInstanceCatalog.getRegistryInstanceMap(transType).putIfAbsent(newRegistryInstance.getGroup(), registryInstanceSet);
            }
            registryInstanceSet.add(newRegistryInstance);
        }
    }

    private static KRegistryInstance parseBaseRegistryInstance(String transType, MServiceDefineMeta mServiceDefineMeta) {
        KRegistryInstance kRegistryInstance = new KRegistryInstance();
        Integer port = transType.equals("http") ? Integer.parseInt(System.getProperty("server.port")) : Integer.parseInt(System.getProperty("dubbo.protocol.port", "20880"));
        kRegistryInstance.setPort(port).setRegistryAppName(KRegistryInstanceCatalog.getRegisterInterfaceName(mServiceDefineMeta.getServiceInterface())).setGroup(StringUtils.isEmpty((String)mServiceDefineMeta.getGroup()) ? "default" : mServiceDefineMeta.getGroup()).setServiceName(mServiceDefineMeta.getServiceName()).setInterfaceClass(mServiceDefineMeta.getServiceInterface()).setTransProtocolType(transType).setTimestamp(System.currentTimeMillis());
        List methodDefineList = mServiceDefineMeta.getMethods();
        for (MServiceDefineMeta.MethodDefine tempMethodDefine : methodDefineList) {
            kRegistryInstance.addMethodName(tempMethodDefine.getServiceMethodName());
        }
        return kRegistryInstance;
    }

    private static Set<String> getAppIds(Properties props) {
        String str = props.getProperty("appIds");
        if (str == null) {
            return appIdSet;
        }
        HashSet<String> appidSet = new HashSet<String>(2);
        if (Instance.isAppSplit()) {
            for (String appId : Instance.parseAppIds((String)str)) {
                appidSet.add(appId);
            }
        }
        return appidSet;
    }

    private static String getRegisterAppName(String appId, String interfaceName) {
        return RegisterAppNameUtils.getRegisterAppName((String)appId, (String)interfaceName);
    }

    private static String getRegisterInterfaceName(String interfaceName) {
        return RegisterAppNameUtils.getRegisterInterfaceName((String)interfaceName);
    }

    static {
        String[] appIds = Instance.getAppIds();
        boolean isCurrentDeployAlone = AppUtils.isDeployAloneApps((String[])appIds);
        if (Instance.isAppSplit() && appIds != null || isCurrentDeployAlone) {
            for (String appId : appIds) {
                if (Instance.getDeployedCloudByApp((String)appId) != null) continue;
                appIdSet.add(appId);
            }
            Set clouds = Instance.getDeployedClouds();
            clouds.forEach(cloud -> {
                String cloudtag = "cloud--" + cloud;
                appIdSet.add(cloudtag);
            });
        }
    }
}

