/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.discovery;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.extension.ExtensionFactory;
import kd.bos.mservice.discovery.KRegistryInstance;
import kd.bos.mservice.discovery.KRegistryInstanceCatalog;
import kd.bos.mservice.discovery.KRegistryInstanceTransform;

public class KRegistryInstanceTransformAdapter<I, O> {
    private String rpcType;
    private KRegistryInstanceTransform<I, O> trans;
    private SourceRegistryType<I, O> sourceRegistryType;
    private static ExtensionFactory<KRegistryInstanceTransform> TRANSFORM_FACTORY = ExtensionFactory.getExtensionFacotry(KRegistryInstanceTransform.class);
    private static Map<String, KRegistryInstanceTransformAdapter> instances = new ConcurrentHashMap<String, KRegistryInstanceTransformAdapter>(2);

    public KRegistryInstanceTransformAdapter(String rpcType, KRegistryInstanceTransform<I, O> trans, SourceRegistryType<I, O> sourceRegistryType) {
        this.rpcType = rpcType;
        this.trans = trans;
        this.sourceRegistryType = sourceRegistryType;
    }

    public static <I, O> KRegistryInstanceTransformAdapter getAdapter(String rpcType, String registryCenterTye, SourceRegistryType<I, O> x) {
        return instances.computeIfAbsent(rpcType + registryCenterTye, k -> {
            KRegistryInstanceTransform trans = (KRegistryInstanceTransform)TRANSFORM_FACTORY.getExtension(registryCenterTye);
            return new KRegistryInstanceTransformAdapter(rpcType, trans, x);
        });
    }

    public List<RegistryInstanceWrapper<O>> getRegistryList(I input) {
        ArrayList<RegistryInstanceWrapper<O>> ls = new ArrayList<RegistryInstanceWrapper<O>>(2);
        Map<String, Set<KRegistryInstance>> group2registryInstanceMap = KRegistryInstanceCatalog.getRegistryInstanceMap(this.rpcType);
        for (Map.Entry<String, Set<KRegistryInstance>> tempMap : group2registryInstanceMap.entrySet()) {
            Set<KRegistryInstance> registryInstanceSet = tempMap.getValue();
            for (KRegistryInstance tempRegistryInstance : registryInstanceSet) {
                I inputCopy = this.sourceRegistryType.copy(input);
                RegistryInstanceWrapper<O> wrapper = new RegistryInstanceWrapper<O>();
                wrapper.setInstacne(this.trans.transform(tempRegistryInstance, inputCopy));
                wrapper.setRegistryAppName(tempRegistryInstance.getRegistryAppName());
                wrapper.setAppId(tempRegistryInstance.getAppId());
                wrapper.setInterfaceName(tempRegistryInstance.getInterfaceClass());
                ls.add(wrapper);
            }
        }
        return ls;
    }

    public static interface SourceRegistryType<I, O> {
        default public I copy(I input) {
            return input;
        }
    }

    public static class RegistryInstanceWrapper<O> {
        private String registryAppName;
        private String interfaceName;
        private String appId;
        private O instacne;

        public String getRegistryAppName() {
            return this.registryAppName;
        }

        public void setRegistryAppName(String registryAppName) {
            this.registryAppName = registryAppName;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public void setInterfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public O getInstacne() {
            return this.instacne;
        }

        public void setInstacne(O instacne) {
            this.instacne = instacne;
        }
    }
}

