/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.endpoint.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.instance.Instance;

public class EndPointInvoker {
    private Map<String, Method> methodCache = new ConcurrentHashMap<String, Method>();

    public Object invoke(String className, String methodName, Object ... paras) {
        try {
            Class<?> clazz = Class.forName(className);
            Method method = this.findServiceMethod(clazz, methodName, paras == null ? 0 : paras.length);
            if (Void.TYPE.equals(method.getReturnType())) {
                method.invoke(clazz, paras);
                return null;
            }
            return method.invoke(clazz, paras);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException("EndPointInvoker invoke " + className + "#" + methodName + " fail:" + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            String msg = String.format("EndPointInvoker invoke service%s.%s's method %s fail:%s", Instance.getAppName(), className, methodName, e.getTargetException().getMessage());
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(msg, e.getTargetException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method findServiceMethod(Class<?> clazz, String method, int parameterLength) {
        String key = clazz.getName() + '#' + method + '#' + parameterLength;
        if (!this.methodCache.containsKey(key)) {
            Map<String, Method> map = this.methodCache;
            synchronized (map) {
                if (!this.methodCache.containsKey(key)) {
                    for (Method m : clazz.getMethods()) {
                        if (!m.getName().equalsIgnoreCase(method) || m.getParameterCount() != parameterLength) continue;
                        this.methodCache.put(key, m);
                        break;
                    }
                }
            }
            if (!this.methodCache.containsKey(key)) {
                throw new RuntimeException("Not Found " + clazz.getName() + "'s method: " + method + " with parameterLength " + parameterLength);
            }
        }
        return this.methodCache.get(key);
    }
}

