/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import kd.bos.armor.core.ArmorException;
import kd.bos.armor.core.slots.block.AbstractRule;
import kd.bos.armor.core.slots.block.flow.FlowRule;
import kd.bos.bundle.BosRes;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.util.ArmorResManager;
import kd.bos.response.ResponseHeaderManage;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;

public class ArmorExceptionHandler {
    private static final Log log = LogFactory.getLog(ArmorExceptionHandler.class);
    private static final String CACHE_CONTROL_KEY = "cosmic.http.proection.enable";
    private static boolean enableCacheControl = Boolean.parseBoolean(System.getProperty("cosmic.http.proection.enable", "true"));
    private static final String MAGIC_STR = "bos-mservice";

    public static void responseException(ArmorException e, ServletResponse response) throws IOException {
        if (response instanceof HttpServletResponse) {
            HttpServletResponse res = (HttpServletResponse)response;
            Map headers = ResponseHeaderManage.getHeaders();
            headers.forEach((k, v) -> res.addHeader(k, v));
            if (enableCacheControl) {
                res.setHeader("Cache-Control", "max-age=0");
                res.setHeader("Expires", "0");
                res.setHeader("X-XSS-Protection", "1");
            }
        }
        String result = ArmorExceptionHandler.toJsonString(e);
        response.setContentType("text/json;charset=utf-8");
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bufferedOutputStream, "utf-8");){
            writer.write(result);
            writer.flush();
        }
        response.flushBuffer();
    }

    private static String toJsonString(ArmorException armorException) {
        try {
            ArrayList acts = new ArrayList(1);
            HashMap<String, Object> act = new HashMap<String, Object>();
            ArrayList params = new ArrayList(1);
            HashMap<String, String> param = new HashMap<String, String>();
            RequestContext.set(null);
            param.put("msg", BosRes.get((String)MAGIC_STR, (String)"CircuitBreakerFilter_0", (String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (Object[])new Object[0]));
            AbstractRule rule = armorException.getRule();
            String logKey = BosRes.get((String)MAGIC_STR, (String)"CircuitBreakerFilter_9", (String)"\u8be6\u7ec6\u65e5\u5fd7\u5173\u952e\u5b57: %1$s", (Object[])new Object[]{TraceIdUtil.createTraceIdString()});
            if (rule != null) {
                String detail = rule instanceof FlowRule ? BosRes.get((String)MAGIC_STR, (String)"CircuitBreakerFilter_7", (String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u6c42\u88ab\u6682\u65f6\u9650\u6d41,\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]) + logKey : BosRes.get((String)MAGIC_STR, (String)"CircuitBreakerFilter_8", (String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u6c42\u88ab\u6682\u65f6\u7194\u65ad,\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]) + logKey;
                String endMsg = ArmorResManager.parseRule(rule) + logKey;
                param.put("detail", detail);
                log.error(endMsg);
            } else {
                param.put("detail", "too many request");
            }
            params.add(param);
            act.put("a", "showMessage");
            act.put("p", params);
            acts.add(act);
            ObjectMapper om = new ObjectMapper();
            return om.writeValueAsString(acts);
        }
        catch (Exception e2) {
            String exceptionMessage = armorException.getMessage();
            if (StringUtils.isNotEmpty((String)exceptionMessage)) {
                exceptionMessage = exceptionMessage.replaceAll("\"", "\\\"").replaceAll("\n", " ").replaceAll("\r", " ");
            }
            return "[{\"p\":[{\"msg\":\"" + exceptionMessage + "\"}],\"a\":\"showMessage\"}]";
        }
    }

    static {
        ConfigurationUtil.observeChange((String)CACHE_CONTROL_KEY, (key, newValue) -> {
            enableCacheControl = Boolean.parseBoolean(System.getProperty(CACHE_CONTROL_KEY, "true"));
        });
    }
}

