/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ParsingUrlUtil {
    private static final String INVOKE_ACTION_DO = "invokeAction.do";
    private static final String BATCH_INVOKE_ACTION_DO = "batchInvokeAction.do";

    public static List<String> parseBatchInvokeAction(String uri, Map<String, String[]> paramMap) {
        ArrayList<String> list = new ArrayList<String>(2);
        try {
            if (!uri.contains(BATCH_INVOKE_ACTION_DO) && !uri.contains(INVOKE_ACTION_DO) || paramMap.size() == 0 || paramMap.get("appId") == null || paramMap.get("f") == null || paramMap.get("ac") == null) {
                list.add(uri);
                list.add("batchInvokeAction");
                return list;
            }
            String[] appIdArr = paramMap.get("appId");
            String[] fArr = paramMap.get("f");
            String[] acArr = paramMap.get("ac");
            if (appIdArr.length == 0 || fArr.length == 0 || acArr.length == 0) {
                list.add(uri);
                list.add("batchInvokeAction");
                return list;
            }
            String appId = appIdArr[0];
            String formId = fArr[0];
            String action = acArr[0];
            if (ParsingUrlUtil.isContainSpecialChar(action)) {
                list.add(uri);
                list.add("batchInvokeAction");
                return list;
            }
            String[] tempArr = uri.contains(BATCH_INVOKE_ACTION_DO) ? uri.split(BATCH_INVOKE_ACTION_DO) : uri.split(INVOKE_ACTION_DO);
            String afterWebUrl = tempArr[0] + appId + '/' + formId + '/' + action;
            String afterServiceMethod = appId + '.' + formId + '.' + action;
            Collections.addAll(list, afterWebUrl, afterServiceMethod);
        }
        catch (Exception e) {
            list.add(uri);
            list.add("batchInvokeAction");
        }
        return list;
    }

    private static boolean isContainSpecialChar(String str) {
        return str.contains("{") || str.contains(":") || str.contains(",") || str.contains("}");
    }
}

