/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.register.extra;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.common.rpc.RegisterAppNameUtils;
import kd.bos.service.register.extra.ExtraRegisterStartService;
import kd.bos.service.register.extra.ExtraServiceRegistry;
import kd.bos.service.register.extra.ServiceRegistration;
import kd.bos.service.register.extra.spi.ExtraAutoServiceRegistration;

public abstract class AbstractExtraAutoServiceRegistration<R extends ServiceRegistration>
implements ExtraAutoServiceRegistration {
    private static final Log log = LogFactory.getLog(ExtraRegisterStartService.class);
    private final AtomicBoolean running = new AtomicBoolean(false);

    protected AbstractExtraAutoServiceRegistration() {
    }

    protected abstract ExtraServiceRegistry<R> getMultiServiceRegistry();

    protected abstract R getMultiRegistration(String var1);

    protected abstract boolean isEnabled();

    public void start(Map<String, Set<String>> interfaceAppIds) {
        if (!this.isEnabled()) {
            log.info("AbstractExtraAutoServiceRegistration Lifecycle disabled. Not starting");
        } else if (!this.running.get()) {
            this.register(interfaceAppIds);
            this.running.compareAndSet(false, true);
        }
    }

    protected void register(Map<String, Set<String>> interfaceAppIds) {
        if (Boolean.getBoolean("mservice.extra.registry.withappname.enable")) {
            this.getMultiServiceRegistry().register(this.getMultiRegistration(Instance.getAppName()));
        } else {
            for (Map.Entry<String, Set<String>> entry : interfaceAppIds.entrySet()) {
                String interfaceName = entry.getKey();
                Set<String> appIdSet = entry.getValue();
                if (appIdSet.isEmpty()) {
                    String appName = this.getRegisterInterfaceName(interfaceName);
                    this.getMultiServiceRegistry().register(this.getMultiRegistration(appName));
                    continue;
                }
                for (String appid : appIdSet) {
                    String appName = this.getRegisterAppName(appid, interfaceName);
                    this.getMultiServiceRegistry().register(this.getMultiRegistration(appName));
                }
            }
        }
    }

    private String getRegisterInterfaceName(String interfaceName) {
        return RegisterAppNameUtils.getRegisterInterfaceName((String)interfaceName);
    }

    public String getRegisterAppName(String appId, String interfaceName) {
        return RegisterAppNameUtils.getRegisterAppName((String)appId, (String)interfaceName);
    }
}

