/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.register.extra.nacos;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import kd.bos.instance.Instance;
import kd.bos.nacos.NacosFactory;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.WebPortUtil;

public class NacosExtraProperties {
    private final String clusterName = Instance.getClusterName().replaceAll("_", "");
    private String appName;
    private String serverAddr;
    private String username;
    private String password;
    private String endpoint;
    private String namespace = "";
    private String ip;
    private int port = -1;
    private String group = "DEFAULT_GROUP";
    private boolean registerEnabled = true;
    private boolean ephemeral = true;
    private float weight = 1.0f;
    private boolean instanceEnabled = true;
    private boolean secure = false;
    private Map<String, String> metadata = new HashMap<String, String>();

    public NacosExtraProperties() {
        this.metadata.put("preserved.register.source", "DEFAULT");
        if (Boolean.getBoolean("nacos.extra.server.secure")) {
            this.metadata.put("secure", "true");
        }
        String url = Objects.toString(System.getProperty("nacos.extra.server.addr"), "");
        Properties properties = NacosFactory.getNacosProperties((String)url);
        String serverAddr = properties.getProperty("serverAddr");
        String namespace = properties.getProperty("namespace");
        String username = properties.getProperty("username");
        String pwd = properties.getProperty("password");
        if (serverAddr.endsWith("/")) {
            this.setServerAddr(serverAddr.substring(0, serverAddr.length() - 1));
        } else {
            this.setServerAddr(serverAddr);
        }
        if (StringUtils.isNotEmpty((String)namespace)) {
            this.setNamespace(namespace);
        } else {
            this.setNamespace(System.getProperty("nacos.extra.registry.namespace", ""));
        }
        if (StringUtils.isNotEmpty((String)username)) {
            this.setUsername(username);
        } else {
            this.setUsername(System.getProperty("nacos.extra.registry.username"));
        }
        if (StringUtils.isNotEmpty((String)pwd)) {
            this.setPassword(pwd);
        } else {
            this.setPassword(System.getProperty("nacos.extra.registry.pwd"));
        }
        this.setEndpoint(System.getProperty("nacos.extra.registry.endpoint", ""));
        this.setIp(System.getProperty("nacos.extra.registry.ip", NetAddressUtils.getLocalIpAddress()));
        this.setPort(Integer.parseInt(WebPortUtil.getWebPort((String)"8080")));
    }

    public Properties getNacosProperties() {
        Properties properties = new Properties();
        properties.put("serverAddr", this.serverAddr);
        properties.put("username", Objects.toString(this.username, ""));
        properties.put("password", Objects.toString(this.password, ""));
        properties.put("namespace", this.namespace);
        if (this.endpoint.contains(":")) {
            int index = this.endpoint.indexOf(":");
            properties.put("endpoint", this.endpoint.substring(0, index));
            properties.put("endpointPort", this.endpoint.substring(index + 1));
        } else {
            properties.put("endpoint", this.endpoint);
        }
        properties.put("clusterName", this.clusterName);
        return properties;
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public final void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public String getUsername() {
        return this.username;
    }

    public final void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public final void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public final void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getIp() {
        return this.ip;
    }

    public final void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public final void setPort(int port) {
        this.port = port;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isRegisterEnabled() {
        return this.registerEnabled;
    }

    public void setRegisterEnabled(boolean registerEnabled) {
        this.registerEnabled = registerEnabled;
    }

    public boolean isInstanceEnabled() {
        return this.instanceEnabled;
    }

    public void setInstanceEnabled(boolean instanceEnabled) {
        this.instanceEnabled = instanceEnabled;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }

    public void setEphemeral(boolean ephemeral) {
        this.ephemeral = ephemeral;
    }
}

