/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.register.extra.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.register.extra.ExtraRegisterStartService;
import kd.bos.service.register.extra.ExtraServiceRegistry;
import kd.bos.service.register.extra.ServiceRegistration;
import kd.bos.service.register.extra.nacos.NacosExtraProperties;
import kd.bos.service.register.extra.nacos.NacosExtraServiceManager;
import kd.bos.service.register.extra.nacos.NacosServiceRegistration;
import kd.bos.util.StringUtils;

public class NacosExtraServiceRegistry
implements ExtraServiceRegistry<ServiceRegistration> {
    private static final Log log = LogFactory.getLog(ExtraRegisterStartService.class);
    private static final String STATUS_UP = "UP";
    private static final String STATUS_DOWN = "DOWN";
    private static final String LOG_MESSAGE_INFO = "nacos registry, {} {} {}:{} register finished";
    private static final String LOG_MESSAGE_ERROR = "nacos registry, {} register failed...{},";
    private static NacosExtraServiceManager nacosServiceManager = new NacosExtraServiceManager();

    @Override
    public void register(ServiceRegistration registration) {
        NacosServiceRegistration multiRegistration = (NacosServiceRegistration)registration;
        NamingService namingService = this.namingService(multiRegistration);
        String serviceId = registration.getServiceId();
        String group = multiRegistration.getNacosMultiProperties().getGroup();
        com.alibaba.nacos.api.naming.pojo.Instance instance = this.getNacosInstanceFromRegistration(multiRegistration);
        try {
            namingService.registerInstance(serviceId, group, instance);
            log.info(LOG_MESSAGE_INFO, new Object[]{group, serviceId, instance.getIp(), instance.getPort()});
        }
        catch (Exception e) {
            log.error(LOG_MESSAGE_ERROR, new Object[]{serviceId, registration.toString(), e});
            throw new KDException(BosErrorCode.bOS, new Object[]{e});
        }
    }

    private NamingService namingService(ServiceRegistration registration) {
        NacosServiceRegistration multiRegistration = (NacosServiceRegistration)registration;
        return nacosServiceManager.getNamingService(multiRegistration.getNacosMultiProperties().getNacosProperties());
    }

    private com.alibaba.nacos.api.naming.pojo.Instance getNacosInstanceFromRegistration(NacosServiceRegistration registration) {
        NacosExtraProperties nacosExtraProperties = registration.getNacosMultiProperties();
        com.alibaba.nacos.api.naming.pojo.Instance instance = new com.alibaba.nacos.api.naming.pojo.Instance();
        instance.setInstanceId(registration.getInstanceId());
        instance.setServiceName(registration.getServiceId());
        instance.setIp(registration.getHost());
        instance.setPort(registration.getPort());
        instance.setWeight((double)nacosExtraProperties.getWeight());
        instance.setClusterName(nacosExtraProperties.getClusterName());
        instance.setEnabled(nacosExtraProperties.isInstanceEnabled());
        instance.setMetadata(new HashMap<String, String>(registration.getMetadata()));
        instance.setEphemeral(nacosExtraProperties.isEphemeral());
        instance.addMetadata("serverInstanceId", Instance.getInstanceId());
        return instance;
    }

    @Override
    public void deregister(ServiceRegistration registration) {
        log.info("De-registering from Nacos Server now...");
        if (StringUtils.isEmpty((String)registration.getServiceId())) {
            log.warn("No dom to de-register for nacos client...");
        } else {
            NacosServiceRegistration multiRegistration = (NacosServiceRegistration)registration;
            NamingService namingService = this.namingService(registration);
            String serviceId = registration.getServiceId();
            String group = multiRegistration.getNacosMultiProperties().getGroup();
            try {
                namingService.deregisterInstance(serviceId, group, registration.getHost(), registration.getPort(), multiRegistration.getNacosMultiProperties().getClusterName());
            }
            catch (Exception var6) {
                log.error("ERR_NACOS_DEREGISTER, de-register failed...{},", (Object)registration.toString(), (Object)var6);
            }
            log.info("De-registration finished.");
        }
    }

    @Override
    public void close() {
        try {
            nacosServiceManager.nacosServiceShutDown();
        }
        catch (NacosException e) {
            log.error("Nacos namingService shutDown failed", (Throwable)e);
        }
    }

    @Override
    public void setStatus(ServiceRegistration registration, String status) {
        if (!STATUS_UP.equalsIgnoreCase(status) && !STATUS_DOWN.equalsIgnoreCase(status)) {
            log.warn("can't support status {},please choose UP or DOWN", (Object)status);
            return;
        }
        NacosServiceRegistration multiRegistration = (NacosServiceRegistration)registration;
        String serviceId = multiRegistration.getServiceId();
        com.alibaba.nacos.api.naming.pojo.Instance instance = this.getNacosInstanceFromRegistration(multiRegistration);
        if (STATUS_DOWN.equalsIgnoreCase(status)) {
            instance.setEnabled(false);
        } else {
            instance.setEnabled(true);
        }
        try {
            Properties nacosProperties = multiRegistration.getNacosMultiProperties().getNacosProperties();
            nacosServiceManager.getNamingMaintainService(nacosProperties).updateInstance(serviceId, multiRegistration.getNacosMultiProperties().getGroup(), instance);
        }
        catch (Exception e) {
            throw new RuntimeException("update nacos instance status fail", e);
        }
    }

    @Override
    public Object getStatus(ServiceRegistration registration) {
        NacosServiceRegistration multiRegistration = (NacosServiceRegistration)registration;
        String serviceName = multiRegistration.getServiceId();
        try {
            List instances = this.namingService(multiRegistration).getAllInstances(serviceName);
            for (com.alibaba.nacos.api.naming.pojo.Instance instance : instances) {
                if (!instance.getIp().equalsIgnoreCase(multiRegistration.getNacosMultiProperties().getIp()) || instance.getPort() != multiRegistration.getNacosMultiProperties().getPort()) continue;
                return instance.isEnabled() ? STATUS_UP : STATUS_DOWN;
            }
        }
        catch (Exception e) {
            log.error("get all instance of {} error,", (Object)serviceName, (Object)e);
        }
        return null;
    }
}

