/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import kd.bos.cache.TempTransResult;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.extension.FileServiceExt;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.fileservice.preview.PreviewService;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public interface FileService
extends PreviewService {
    public String upload(FileItem var1);

    public List<String> upload(FileItem[] var1);

    public String compressPicUpload(FileItem var1, long var2);

    public void download(String var1, OutputStream var2, String var3);

    public void download(String var1, HttpServletResponse var2, String var3);

    public Map<String, Object> download(String var1, String var2, String var3);

    public InputStream download(String var1, Map<String, String> var2, Map<String, String> var3);

    public InputStream getInputStream(String var1);

    public void delete(String var1);

    public void batchDownload(BatchDownloadRequest var1, OutputStream var2, String var3);

    public void batchDownload(BatchDownloadRequest var1, HttpServletResponse var2, String var3);

    public List<String> getForbiddenExtensions();

    public List<String> getAllowExtensions();

    @SdkInternal
    public int getMaxUploadSize();

    default public long maxUploadSize() {
        return this.getMaxUploadSize();
    }

    public String getTicket();

    public boolean exists(String var1);

    @SdkInternal
    default public boolean needAuth() {
        return false;
    }

    default public String getHttpUrlPrefix() {
        return "";
    }

    @SdkInternal
    default public String authUserName() {
        return null;
    }

    @SdkInternal
    default public String authPassWord() {
        return null;
    }

    @Deprecated
    @SdkInternal
    default public String getRealPath(String path) {
        return path;
    }

    @Deprecated
    @SdkInternal
    default public String savePath(String path) {
        return path;
    }

    @Deprecated
    @SdkInternal
    default public InputStream checkFile(InputStream in, String fileName) {
        return in;
    }

    default public FileServiceExt getFileServiceExt() {
        return FileServiceExtFactory.getDefaultFileServiceExt();
    }

    @SdkInternal
    default public List<String> getFileServerList() {
        return Collections.emptyList();
    }

    @SdkInternal
    default public void checkServer(String url) {
    }

    @SdkInternal
    default public long getFileSize(String path) {
        return -1L;
    }

    @SdkInternal
    default public boolean supportTempfile() {
        return false;
    }

    @SdkInternal
    default public boolean supportTempTransToPersist() {
        return false;
    }

    default public boolean _existsNopm(String path) {
        return this.exists(path);
    }

    @SdkInternal
    default public List<TempTransResult> moveTempFile(List<FileItem> persistFileItems) {
        String msg = "current fileservice mode is not support the persistence of trans temp file";
        throw new KDException(BosErrorCode.uploadFailed, new Object[]{msg});
    }

    @SdkInternal
    default public String getPublicKey() {
        return "";
    }
}

