/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice;

import java.lang.reflect.Method;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.impl.AttachmentFileService;
import kd.bos.fileservice.impl.EreceiptService;
import kd.bos.fileservice.impl.ImageFileService;
import kd.bos.fileservice.manage.FileServiceType;
import kd.bos.fileservice.spiimpl.AttachmentFileServiceConfig;
import kd.bos.fileservice.spiimpl.EreceiptFileServiceConfig;
import kd.bos.fileservice.spiimpl.FileServiceImpl;
import kd.bos.fileservice.spiimpl.ImageFileServiceConfig;
import kd.bos.filestorage.spi.FileStorageConfig;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FileServiceFactory {
    private static final String ATTACHMENT_FILESTORAGE_CLASSNAME = "attachmentServer.fileStorage.className";
    private static final String IMAGE_FILESTORAGE_CLASSNAME = "imageServer.fileStorage.className";
    private static final String ERECEIPT_FILESTORAGE_CLASSNAME = "ereceipt.fileStorage.className";
    private static final String LIGHT_FILE_STORAGE_CLASSNAME = "kd.bos.fileservice.lightfilestorage.LightFileStorage";
    private static final String MINIO_IMPLEMENTS_CLASSNAME = "kd.bos.filestorage.minio.MinIOStorage";
    private static final String ATTACHMENTSERVER_TYPE = "attachmentServer.type";
    private static final String IMAGESERVER_TYPE = "imageServer.type";
    private static final String ERECEIPT_TYPE = "ereceipt.type";
    private static final String ENABLE_ATTACHMENT_CENTER = "enable_attachment_center";
    private static final Log log = LogFactory.getLog(FileServiceFactory.class);
    private static Method getOrCreateRequestContext;
    private static Method getTenantId;
    private static Method fileServiceCreateMethod;

    public static FileService getImageFileService() {
        FileService fileService;
        if (Instance.isLightWeightDeploy()) {
            return FileServiceFactory.getLightFileService();
        }
        if (FileServiceFactory.isDefaultImageFileStorageClass()) {
            fileService = new ImageFileService();
        } else {
            String fileStorageClassName = FileServiceFactory.getPropertyByTenant(IMAGE_FILESTORAGE_CLASSNAME);
            if ("minio".equals(FileServiceFactory.getPropertyByTenant(IMAGESERVER_TYPE))) {
                fileStorageClassName = MINIO_IMPLEMENTS_CLASSNAME;
            }
            FileStorageConfig fileStorageConfig = new ImageFileServiceConfig().getConfig();
            fileService = new FileServiceImpl(fileStorageConfig, FileServiceType.IMAGE.name(), fileStorageClassName);
        }
        return FileServiceFactory.newImageService(fileService);
    }

    public static FileService getAttachmentFileService() {
        FileService fileService;
        if (Instance.isLightWeightDeploy()) {
            return FileServiceFactory.getLightFileService();
        }
        if (FileServiceFactory.isDefaultAttachmentFileStorageClass()) {
            fileService = new AttachmentFileService();
        } else {
            String fileStorageClassName = FileServiceFactory.getPropertyByTenant(ATTACHMENT_FILESTORAGE_CLASSNAME);
            if ("minio".equals(FileServiceFactory.getPropertyByTenant(ATTACHMENTSERVER_TYPE))) {
                fileStorageClassName = MINIO_IMPLEMENTS_CLASSNAME;
            }
            FileStorageConfig fileStorageConfig = new AttachmentFileServiceConfig().getConfig();
            fileService = new FileServiceImpl(fileStorageConfig, FileServiceType.ATTACHMENT.name(), fileStorageClassName);
        }
        return FileServiceFactory.newFileService(fileService);
    }

    @SdkInternal
    public static FileService getEreceiptService() {
        FileService fileService;
        if (Instance.isLightWeightDeploy()) {
            return FileServiceFactory.getLightFileService();
        }
        if (FileServiceFactory.isDefaultEreceiptFileStorageClass()) {
            fileService = new EreceiptService();
        } else {
            String fileStorageClassName = FileServiceFactory.getPropertyByTenant(ERECEIPT_FILESTORAGE_CLASSNAME);
            if ("minio".equals(FileServiceFactory.getPropertyByTenant(ERECEIPT_TYPE))) {
                fileStorageClassName = MINIO_IMPLEMENTS_CLASSNAME;
            }
            FileStorageConfig fileStorageConfig = new EreceiptFileServiceConfig().getConfig();
            fileService = new FileServiceImpl(fileStorageConfig, FileServiceType.ERECEIPT.name(), fileStorageClassName);
        }
        return FileServiceFactory.newFileService(fileService);
    }

    @SdkInternal
    public static FileService getLightFileService() {
        FileStorageConfig fileStorageConfig = new FileStorageConfig();
        FileServiceImpl fileService = new FileServiceImpl(fileStorageConfig, FileServiceType.LIGHT.name(), LIGHT_FILE_STORAGE_CLASSNAME);
        return FileServiceFactory.newFileService(fileService);
    }

    @SdkInternal
    public static boolean isDefaultAttachmentFileStorageClass() {
        String fileServiceype = FileServiceFactory.getPropertyByTenant(ATTACHMENTSERVER_TYPE);
        if (StringUtils.isNotEmpty((String)fileServiceype)) {
            return false;
        }
        String className = FileServiceFactory.getPropertyByTenant(ATTACHMENT_FILESTORAGE_CLASSNAME);
        return StringUtils.isEmpty((String)className);
    }

    @SdkInternal
    public static boolean isDefaultImageFileStorageClass() {
        String fileServiceype = FileServiceFactory.getPropertyByTenant(IMAGESERVER_TYPE);
        if (StringUtils.isNotEmpty((String)fileServiceype)) {
            return false;
        }
        String className = FileServiceFactory.getPropertyByTenant(IMAGE_FILESTORAGE_CLASSNAME);
        return StringUtils.isEmpty((String)className);
    }

    @SdkInternal
    public static boolean isDefaultEreceiptFileStorageClass() {
        String fileServiceype = FileServiceFactory.getPropertyByTenant(ERECEIPT_TYPE);
        if (StringUtils.isNotEmpty((String)fileServiceype)) {
            return false;
        }
        String className = FileServiceFactory.getPropertyByTenant(ERECEIPT_FILESTORAGE_CLASSNAME);
        return StringUtils.isEmpty((String)className);
    }

    private static FileService newFileService(FileService fileService) {
        return FileServiceFactory.newFileServiceProxy(fileService, "0");
    }

    private static FileService newImageService(FileService fileService) {
        return FileServiceFactory.newFileServiceProxy(fileService, "1");
    }

    private static FileService newFileServiceProxy(FileService fileService, String type) {
        String isEnableAttachCenter = System.getProperty(ENABLE_ATTACHMENT_CENTER);
        if ("false".equals(isEnableAttachCenter)) {
            return fileService;
        }
        String className = "kd.bos.service.attachment.FileServiceInterceptor";
        try {
            if (fileServiceCreateMethod == null) {
                Class<?> cs = Class.forName(className);
                fileServiceCreateMethod = cs.getMethod("createFileService", FileService.class, String.class);
            }
            return (FileService)fileServiceCreateMethod.invoke(null, fileService, type);
        }
        catch (Exception e) {
            log.error("init class " + className + " error:", (Throwable)e);
            return fileService;
        }
    }

    public static String getPropertyByTenant(String property) {
        String tenantId = FileServiceFactory.getTenantId();
        if (StringUtils.isEmpty((String)tenantId)) {
            return System.getProperty(property);
        }
        String pValue = System.getProperty(tenantId + "_" + property);
        if (StringUtils.isEmpty((String)pValue)) {
            pValue = System.getProperty(property);
        }
        return pValue;
    }

    private static String getTenantId() {
        try {
            return (String)getTenantId.invoke(getOrCreateRequestContext.invoke(null, new Object[0]), new Object[0]);
        }
        catch (Exception e) {
            return "";
        }
    }

    static {
        try {
            Class<?> cls = Class.forName("kd.bos.context.RequestContext");
            getOrCreateRequestContext = cls.getMethod("getOrCreate", new Class[0]);
            getTenantId = cls.getMethod("getTenantId", new Class[0]);
        }
        catch (Exception e) {
            log.warn("FileServiceFactory static error.", (Throwable)e);
        }
    }
}

