/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class ResolveUtils {
    private static final Pattern COMMA_PATTERN = Pattern.compile("\\s*,\\s*");
    private static final Pattern EQUAL_PATTERN = Pattern.compile("\\s*=\\s*");

    public static Map<String, String> resolveJson(String headString) {
        HashMap<String, String> resultMap = new HashMap<String, String>(4);
        JSONObject obj = JSONObject.parseObject((String)headString);
        for (String key : obj.keySet()) {
            resultMap.put(key, obj.getString(key));
        }
        return resultMap;
    }

    public static String resolveJson(Map<String, String> map) {
        return JSONObject.toJSONString(map);
    }

    public static Map<String, String> resolveOld(String headString) {
        String[] keyValue = COMMA_PATTERN.split(headString);
        int len = 0;
        len = keyValue != null && keyValue.length > 0 ? keyValue.length : len;
        HashMap<String, String> map = new HashMap<String, String>(len);
        if (len > 0) {
            for (String item : keyValue) {
                String[] entry = EQUAL_PATTERN.split(item);
                map.put(entry[0], entry[1]);
            }
        }
        return map;
    }

    public static String resolveOld(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getKey() == null) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return sb.toString();
    }
}

