/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.config;

import kd.bos.fileservice.utils.TAUtil;
import kd.bos.util.ConfigurationUtil;

public class FileServiceTenantConfig {
    public static final ConfigItem<String> FILE_SECURITY_TEMP_FILE_DIR = new ConfigItem<String>("fileSecurity.temp.dir", "", "encrypt or decrypt tempFile storage dir");
    public static final ConfigItem<Long> FILE_SECURITY_DECRYPT_SURVIVAL = new ConfigItem<Long>("fileSecurity.decrypt.survival", 300000L, "decrypt tempFile survival time");
    public static final ConfigItem<Long> FILE_SECURITY_ENCRYPT_SURVIVAL = new ConfigItem<Long>("fileSecurity.encrypt.survival", 60000L, "encrypt tempFile survival time");
    public static final ConfigItem<Boolean> FILE_SECURITY_ENCRYPT_ENABLE = new ConfigItem<Boolean>("fileSecurity.encrypt.enable", false, "Enable file encrypt");
    public static final ConfigItem<Boolean> FILE_SECURITY_ENCRYPT_DEFAULT = new ConfigItem<Boolean>("fileSecurity.encrypt.default", false, "Default encryption or not");
    public static final ConfigItem<String> FILE_SECURITY_ENCRYPT_INCLUDE = new ConfigItem<String>("fileSecurity.encrypt.include", "attachment", "File security include service scene");
    public static final ConfigItem<Boolean> FILE_SECURITY_DECRYPT_ENABLE = new ConfigItem<Boolean>("fileSecurity.decrypt.enable", false, "Enable file decrypt");
    public static final ConfigItem<String> FILE_SECURITY_DECRYPT_INCLUDE = new ConfigItem<String>("fileSecurity.decrypt.include", "attachment", "File security include service scene");
    public static final ConfigItem<Boolean> DOWNLOAD_FILE_SIZE_DEF_ENABLE = new ConfigItem<Boolean>("fileservice.download.size.default.enable", false, "Enable default implement");
    public static final ConfigItem<Boolean> DOWNLOAD_EXT_DECIDE_ENABLE = new ConfigItem<Boolean>("fileservice.download.ext.decide.enable", true, "When getting the file size, based on whether there is an extension");

    public static class ConfigItem<T> {
        private final String key;
        private final T defaultValue;
        private final String description;

        public ConfigItem(String key, T defaultValue, String description) {
            this.key = key;
            this.defaultValue = defaultValue;
            this.description = description;
        }

        public T getDefault() {
            return this.defaultValue;
        }

        public boolean getBooleanTenant() {
            String tenantId = TAUtil.getTenantId();
            return ConfigurationUtil.getBoolean((String)(tenantId + "_" + this.key), (Boolean)((Boolean)this.defaultValue));
        }

        public String toString() {
            return String.format("[%s=%s,%s]", this.key, this.defaultValue, this.description);
        }

        public String getKey() {
            return this.key;
        }
    }
}

