/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.encrypter;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.fileservice.encrypter.MyEncrypterUtil;
import kd.bos.util.PropertiesUtil;
import org.apache.commons.codec.binary.Base64;

public class FileServerEncrypter {
    private static final Base64.Encoder myEncoder = java.util.Base64.getEncoder();
    private static final String KDPASSWORD_BASE64 = new String(myEncoder.encode("kdpassword".getBytes()));
    private static final String HELLO_BASE64 = new String(myEncoder.encode("Hello".getBytes()));
    public static final String ENCRYPTET_KEY = PropertiesUtil.getConstant((String)"ENCRYPTET_KEY");
    private static Cipher cacheDecCipher = null;

    public static String encode(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return FileServerEncrypter.encode0(str);
    }

    public static String decode(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return FileServerEncrypter.decode0(str);
    }

    private static String encode0(String str) {
        String encodeStr = FileServerEncrypter.encrypt(str);
        String rs = MyEncrypterUtil.reverse(encodeStr);
        int middle = rs.length() / 2;
        rs = rs.substring(0, middle) + "D" + rs.substring(middle, rs.length());
        return HELLO_BASE64 + rs + KDPASSWORD_BASE64;
    }

    private static String decode0(String str) {
        try {
            if (!FileServerEncrypter.checkEncrypt(str)) {
                return str;
            }
            int b = HELLO_BASE64.length();
            int e = str.indexOf(KDPASSWORD_BASE64);
            String encodeStr = str.substring(b, e);
            encodeStr = MyEncrypterUtil.reverse(encodeStr);
            StringBuilder builder = new StringBuilder(encodeStr);
            if (encodeStr.length() % 2 != 0) {
                builder.deleteCharAt(encodeStr.length() / 2);
            } else {
                builder.deleteCharAt((encodeStr.length() - 1) / 2);
            }
            encodeStr = builder.toString();
            String original = FileServerEncrypter.decrypt(encodeStr);
            return original;
        }
        catch (Exception ex) {
            throw new RuntimeException("decrypt error,", ex);
        }
    }

    private static String encrypt(String xmlStr) {
        if (xmlStr == null) {
            return null;
        }
        byte[] encrypt = null;
        try {
            encrypt = xmlStr.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        byte[] md5Hasn = null;
        try {
            if (encrypt != null) {
                md5Hasn = FileServerEncrypter.md5Hash(encrypt, 0, encrypt.length);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (encrypt != null && md5Hasn != null) {
            byte[] totalByte = FileServerEncrypter.addMD5(md5Hasn, encrypt);
            byte[] key = new byte[8];
            byte[] iv = new byte[8];
            new SecureRandom().nextBytes(iv);
            FileServerEncrypter.getKeyIV(ENCRYPTET_KEY, key, iv);
            SecretKeySpec deskey = new SecretKeySpec(key, "DES");
            IvParameterSpec ivParam = new IvParameterSpec(iv);
            byte[] temp = null;
            try {
                temp = FileServerEncrypter.desCbcEncrypt(totalByte, deskey, ivParam);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return Base64.encodeBase64String((byte[])temp);
        }
        return null;
    }

    private static byte[] desCbcEncrypt(byte[] sourceBuf, SecretKeySpec deskey, IvParameterSpec ivParam) throws Exception {
        Cipher encrypt = FileServerEncrypter.getCacheDecCiphere();
        encrypt.init(1, (Key)deskey, ivParam);
        byte[] cipherByte = encrypt.doFinal(sourceBuf, 0, sourceBuf.length);
        return cipherByte;
    }

    private static Cipher getCacheDecCiphere() throws NoSuchPaddingException, NoSuchAlgorithmException {
        if (cacheDecCipher == null) {
            cacheDecCipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
        }
        return cacheDecCipher;
    }

    private static String decrypt(String xmlStr) throws UnsupportedEncodingException {
        byte[] encBuf = Base64.decodeBase64((String)xmlStr);
        byte[] key = new byte[8];
        byte[] iv = new byte[8];
        new SecureRandom().nextBytes(iv);
        FileServerEncrypter.getKeyIV(ENCRYPTET_KEY, key, iv);
        SecretKeySpec deskey = new SecretKeySpec(key, "DES");
        IvParameterSpec ivParam = new IvParameterSpec(iv);
        byte[] temp = null;
        try {
            temp = FileServerEncrypter.desCbcDecrypt(encBuf, deskey, ivParam);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] md5Hash = null;
        try {
            if (temp != null) {
                md5Hash = FileServerEncrypter.md5Hash(temp, 16, temp.length - 16);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (md5Hash != null) {
            for (int i = 0; i < md5Hash.length; ++i) {
                if (md5Hash[i] == temp[i]) continue;
                throw new RuntimeException("MD5 Check Fail");
            }
        }
        if (temp != null) {
            return new String(temp, 16, temp.length - 16, "utf-8");
        }
        return null;
    }

    private static byte[] md5Hash(byte[] buf, int offset, int length) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(buf, offset, length);
        return md.digest();
    }

    private static byte[] desCbcDecrypt(byte[] sourceBuf, SecretKeySpec deskey, IvParameterSpec ivParam) throws Exception {
        Cipher decrypt = FileServerEncrypter.getCacheDecCiphere();
        decrypt.init(2, (Key)deskey, ivParam);
        byte[] cipherByte = decrypt.doFinal(sourceBuf, 0, sourceBuf.length);
        return cipherByte;
    }

    private static byte[] addMD5(byte[] md5Byte, byte[] bodyByte) {
        int length = bodyByte.length + md5Byte.length;
        byte[] resutlByte = new byte[length];
        for (int i = 0; i < length; ++i) {
            resutlByte[i] = i < md5Byte.length ? md5Byte[i] : bodyByte[i - md5Byte.length];
        }
        return resutlByte;
    }

    private static void getKeyIV(String encryptKey, byte[] key, byte[] iv) {
        byte[] buf = null;
        buf = Base64.decodeBase64((String)encryptKey);
        System.arraycopy(buf, 0, key, 0, key.length);
        System.arraycopy(buf, 8, iv, 0, iv.length);
    }

    private static boolean checkEncrypt(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        return str.startsWith(HELLO_BASE64) && str.endsWith(KDPASSWORD_BASE64);
    }
}

