/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.extension;

import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExt;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FileServiceExtFactory {
    private static final Log logger = LogFactory.getLog(FileServiceExtFactory.class);
    private static final String ATTACHMENT_SERVICE_CLASSNAME_V3 = "custom.fileservice.ext.impl.classname";
    private static final String IMAGE_SERVICE_CLASSNAME_V3 = "custom.image.fileservice.ext.impl.classname";
    private static final String ATTACHMENT_SERVICE_CLASSNAME_V2 = "fileservice.ext.impl.classname";
    private static final String IMAGE_SERVICE_CLASSNAME_V2 = "image.fileservice.ext.impl.classname";
    private static final String ATTACHMENT_SERVICE_CLASSNAME_V1 = "filepath.impl.classname";
    private static final String IMAGE_SERVICE_CLASSNAME_V1 = "image.filepath.impl.classname";

    public static boolean hasAttachFileServiceExt() {
        String className = FileServiceFactory.getPropertyByTenant(ATTACHMENT_SERVICE_CLASSNAME_V3);
        if (StringUtils.isNotEmpty((String)className)) {
            return true;
        }
        className = FileServiceFactory.getPropertyByTenant(ATTACHMENT_SERVICE_CLASSNAME_V2);
        if (StringUtils.isNotEmpty((String)className)) {
            return !"kd.bos.service.attachment.FilePathService".equals(className);
        }
        className = FileServiceFactory.getPropertyByTenant(ATTACHMENT_SERVICE_CLASSNAME_V1);
        if (StringUtils.isNotEmpty((String)className)) {
            return !"kd.bos.service.attachment.FilePathService".equals(className);
        }
        return false;
    }

    public static boolean hasImageFileServiceExt() {
        String className = FileServiceFactory.getPropertyByTenant(IMAGE_SERVICE_CLASSNAME_V3);
        if (StringUtils.isNotEmpty((String)className)) {
            return true;
        }
        className = FileServiceFactory.getPropertyByTenant(IMAGE_SERVICE_CLASSNAME_V2);
        if (StringUtils.isNotEmpty((String)className)) {
            return !"kd.bos.service.image.ImageFilePathService".equals(className);
        }
        className = FileServiceFactory.getPropertyByTenant(IMAGE_SERVICE_CLASSNAME_V1);
        if (StringUtils.isNotEmpty((String)className)) {
            return !"kd.bos.service.image.ImageFilePathService".equals(className);
        }
        return false;
    }

    public static FileServiceExt getAttachFileServiceExt() {
        String className = FileServiceExtFactory.getAttachFileServiceExtClass();
        if (!StringUtils.isEmpty((String)className)) {
            try {
                logger.debug("getAttachFileServiceExt class " + className);
                return (FileServiceExt)Class.forName(className).newInstance();
            }
            catch (Exception t) {
                logger.error("init class " + className + " error:", (Throwable)t);
            }
        }
        return new DefaultFileServiceExt();
    }

    private static String getAttachFileServiceExtClass() {
        String className = FileServiceFactory.getPropertyByTenant(ATTACHMENT_SERVICE_CLASSNAME_V3);
        if (StringUtils.isEmpty((String)className)) {
            className = FileServiceFactory.getPropertyByTenant(ATTACHMENT_SERVICE_CLASSNAME_V2);
        }
        if (StringUtils.isEmpty((String)className)) {
            className = FileServiceFactory.getPropertyByTenant(ATTACHMENT_SERVICE_CLASSNAME_V1);
        }
        return className;
    }

    public static FileServiceExt getImageFileServiceExt() {
        String className = FileServiceExtFactory.getImageFileServiceExtClass();
        if (!StringUtils.isEmpty((String)className)) {
            try {
                logger.debug("getImageFileServiceExt class " + className);
                return (FileServiceExt)Class.forName(className).newInstance();
            }
            catch (Exception t) {
                logger.error("init class " + className + " error:", (Throwable)t);
            }
        }
        return new DefaultFileServiceExt();
    }

    private static String getImageFileServiceExtClass() {
        String className = FileServiceFactory.getPropertyByTenant(IMAGE_SERVICE_CLASSNAME_V3);
        if (StringUtils.isEmpty((String)className)) {
            className = FileServiceFactory.getPropertyByTenant(IMAGE_SERVICE_CLASSNAME_V2);
        }
        if (StringUtils.isEmpty((String)className)) {
            className = FileServiceFactory.getPropertyByTenant(IMAGE_SERVICE_CLASSNAME_V1);
        }
        return className;
    }

    public static FileServiceExt getDefaultFileServiceExt() {
        return new DefaultFileServiceExt();
    }

    static class DefaultFileServiceExt
    implements FileServiceExt {
        DefaultFileServiceExt() {
        }
    }
}

