/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.extension;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import kd.bos.fileservice.extension.FileServiceExt;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ImageFileServiceExtTestImpl2
implements FileServiceExt {
    private static final Log logger = LogFactory.getLog(ImageFileServiceExtTestImpl2.class);
    private static Method getRealPath;
    private static Method checkFile;
    private static Method save;
    private static Object instance;

    @Override
    public InputStream checkFile(InputStream in, String fileName) {
        logger.debug("\u6269\u5c55\u5b9e\u73b0\u4e8c\uff0ccheckFile, fileName: " + fileName);
        try {
            return (InputStream)checkFile.invoke(instance, in, fileName);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error("checkFile, fileName: " + fileName, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getRealPath(String idOrPath) {
        logger.debug("\u6269\u5c55\u5b9e\u73b0\u4e8c\uff0cgetRealPath, idOrPath: " + idOrPath);
        try {
            return (String)getRealPath.invoke(instance, idOrPath);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error("getRealPath, idOrPath: " + idOrPath, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String save(String path) {
        logger.debug("\u6269\u5c55\u5b9e\u73b0\u4e8c\uff0csave, path: " + path);
        try {
            return (String)save.invoke(instance, path);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error("save, path: " + path, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream encode(String originalPath, InputStream inputStream) {
        logger.debug("\u6269\u5c55\u5b9e\u73b0\u4e8c\uff0c\u8fdb\u5165\u52a0\u5bc6\u7b97\u6cd5\uff0c\u6587\u4ef6\uff1a" + originalPath);
        return inputStream;
    }

    @Override
    public InputStream decode(String originalPath, InputStream inputStream) {
        logger.debug("\u6269\u5c55\u5b9e\u73b0\u4e8c\uff0c\u8fdb\u5165\u89e3\u5bc6\u7b97\u6cd5\uff0c\u6587\u4ef6\uff1a " + originalPath);
        return inputStream;
    }

    static {
        try {
            Class<?> cls = Class.forName("kd.bos.service.image.ImageFilePathService");
            instance = cls.newInstance();
            getRealPath = cls.getMethod("getRealPath", String.class);
            checkFile = cls.getMethod("checkFile", InputStream.class, String.class);
            save = cls.getMethod("save", String.class);
        }
        catch (Exception e) {
            logger.warn("FileServiceExtTestImpl static error.", (Throwable)e);
        }
    }
}

