/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.extension;

import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.PreviewExt;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class PreviewExtFactory {
    private static final Log logger = LogFactory.getLog(PreviewExtFactory.class);
    private static final String PREVIEW_EXT_CLASS_NAME_KEY = "fileservice.preview.ext.impl.classname";
    private static final String PREVIEW_EXT_URL_TIMEOUT_SEC = "fileservice.preview.ext.url.timeout.sec";
    private static final int DEFAULT_TIMEOUT = 300;

    public static PreviewExt getPreviewExt() {
        String className = FileServiceFactory.getPropertyByTenant(PREVIEW_EXT_CLASS_NAME_KEY);
        if (!StringUtils.isEmpty((String)className)) {
            try {
                logger.debug("ext class " + className);
                return (PreviewExt)Class.forName(className).newInstance();
            }
            catch (Exception t) {
                logger.error("init class " + className + " error:", (Throwable)t);
            }
        }
        return new DefaultPreviewExt();
    }

    public static boolean hasPreviewExt() {
        String className = FileServiceFactory.getPropertyByTenant(PREVIEW_EXT_CLASS_NAME_KEY);
        return StringUtils.isNotEmpty((String)className);
    }

    public static int getUrlTimeoutSec() {
        String timeout = FileServiceFactory.getPropertyByTenant(PREVIEW_EXT_URL_TIMEOUT_SEC);
        try {
            if (StringUtils.isNotEmpty((String)timeout)) {
                return Integer.parseInt(timeout);
            }
        }
        catch (Exception e) {
            logger.error("get url timeout error:", (Throwable)e);
        }
        return 300;
    }

    static class DefaultPreviewExt
    implements PreviewExt {
        DefaultPreviewExt() {
        }
    }
}

