/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.image;

import com.alibaba.fastjson.JSON;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import kd.bos.util.ExceptionUtils;

public class ImageDownLoadFilter
implements Filter {
    public static final String IMAGE_ACTION_CLASS = "kd.bos.web.actions.ImageAction";
    public static final String IMAGE_DOWNLOAD = "downloadImage";
    public static final String PATTERN = "/attachment/downloadImage";
    private Object imageActionObj;
    private Method downloadImageMethod;

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            Class<?> clazz = Class.forName(IMAGE_ACTION_CLASS);
            this.imageActionObj = clazz.newInstance();
            this.downloadImageMethod = clazz.getMethod(IMAGE_DOWNLOAD, HttpServletRequest.class, HttpServletResponse.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Init kd.bos.web.actions.ImageAction fail", e);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.downloadImage(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    public void downloadImage(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        String servletPath = httpRequest.getServletPath();
        final String path = servletPath.substring(PATTERN.length());
        httpResponse.setHeader("Cache-Control", "max-age=3600");
        try {
            this.downloadImageMethod.invoke(this.imageActionObj, new HttpServletRequestWrapper(httpRequest){

                public String getParameter(String name) {
                    if ("path".equals(name)) {
                        return path;
                    }
                    return super.getParameter(name);
                }
            }, httpResponse);
        }
        catch (IllegalAccessException e) {
            this.writeErrorMessage(httpResponse, "reflect invoke kd.bos.web.actions.ImageAction#downloadImage error:" + e.getMessage());
        }
        catch (InvocationTargetException e) {
            String msg = String.format("downloadImage fail:%s", e.getTargetException().getMessage());
            if (e.getTargetException() instanceof Exception) {
                msg = msg + "\n" + ExceptionUtils.getExceptionStackTraceMessage((Exception)((Exception)e.getTargetException()));
            }
            this.writeErrorMessage(httpResponse, msg);
        }
    }

    private void writeErrorMessage(HttpServletResponse servletResponse, String message) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("status", "error");
        result.put("description", message);
        servletResponse.setContentType("text/html;charset=utf-8");
        servletResponse.setHeader("Cache-Control", "no-cache");
        servletResponse.setHeader("Cache-Control", "no-store");
        servletResponse.setHeader("Pragma", "no-cache");
        servletResponse.setDateHeader("Expires", 0L);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream((OutputStream)servletResponse.getOutputStream()), "utf-8");){
            writer.write(JSON.toJSONString(result));
            writer.flush();
        }
    }
}

