/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.impl;

import kd.bos.fileservice.config.FileServiceTenantConfig;
import kd.bos.fileservice.extension.FileServiceExt;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.fileservice.impl.AbstractFileService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class AttachmentFileService
extends AbstractFileService {
    public static final String FILESERVER_HTTP_URL = "attachmentServer.url";
    public static final String FILESERVER_PREVIEW_URL = "yunpan.previewUrl";
    private static final String PREVIEW_CACHE_ENABLE = "filepreview.cache.enable";
    private static final int DEFAULT_UPLOADTIMEOUT = 60;
    private static final boolean DEFAULT_PREVIEWCACHEENABLE = true;
    private static Log logger = LogFactory.getLog(AttachmentFileService.class);

    public static int getUploadTimeout() {
        String s = System.getProperty("attachmentServer.upload.timeout");
        if (s != null) {
            return Integer.parseInt(s);
        }
        return 60;
    }

    private static int getBufferSize() {
        return Integer.parseInt(System.getProperty("filepreview.bufferSize", "8"));
    }

    public static boolean isPreviewcacheEnable() {
        String isCacheEnable = System.getProperty(PREVIEW_CACHE_ENABLE);
        if (isCacheEnable != null && !"".equals(isCacheEnable)) {
            return Boolean.parseBoolean(isCacheEnable);
        }
        return true;
    }

    public AttachmentFileService() {
        super(FILESERVER_HTTP_URL, FILESERVER_PREVIEW_URL, AttachmentFileService.getUploadTimeout(), AttachmentFileService.isPreviewcacheEnable(), AttachmentFileService.getBufferSize());
    }

    @Override
    public int getMaxUploadSize() {
        return Integer.parseInt(System.getProperty("attachmentServer.maxFileSize", "52428800"));
    }

    @Override
    public long maxUploadSize() {
        return Long.parseLong(System.getProperty("attachmentServer.maxFileSize", "52428800"));
    }

    @Override
    public FileServiceExt getFileServiceExt() {
        return FileServiceExtFactory.getAttachFileServiceExt();
    }

    @Override
    public long getFileSize(String path) {
        if (FileServiceTenantConfig.DOWNLOAD_EXT_DECIDE_ENABLE.getBooleanTenant() && FileServiceExtFactory.hasAttachFileServiceExt()) {
            logger.info("has ext, return -1");
            return -1L;
        }
        return super.getFileSize(path);
    }
}

