/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kd.bos.api.Probe;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.ResolveUtils;
import kd.bos.fileservice.impl.FileServiceVersion;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class HttpFileClient {
    private static final String FILESERVER_CLIENT_READ_TIMEOUT = "fileserver.client.readTimeout";
    private static final String FILESERVER_CLIENT_CONNECT_TIMEOUT = "fileserver.client.connectTimeout";
    private static final String FILESERVER_SSL_KEYSTORE_KEY = "fileserver.ssl.keystore";
    private static final String FILESERVER_SSL_KEYPASS_KEY = "fileserver.ssl.keypass";
    private static Log log = LogFactory.getLog(HttpFileClient.class);

    public static Map<String, String> sendFile(String uploadUrl, int uploadTimeout, InputStream in, Map<String, String> header) throws InterruptedException {
        int connectTimeout = Integer.parseInt(System.getProperty(FILESERVER_CLIENT_CONNECT_TIMEOUT, "5000"));
        header.put("magic", "kdcomicinternal");
        String headerStr = ResolveUtils.resolveJson(header);
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = HttpFileClient.getHttpClient(uploadUrl);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(uploadTimeout).build();
            HttpPost httpPost = new HttpPost(uploadUrl);
            httpPost.setConfig(requestConfig);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addBinaryBody("file", in, ContentType.MULTIPART_FORM_DATA, "filename1");
            builder.addTextBody("header", headerStr, ContentType.APPLICATION_JSON);
            httpPost.setEntity(builder.build());
            String ticket = header.get("ticket");
            if (ticket != null) {
                httpPost.addHeader("Cookie", "ticket=" + ticket);
            }
            Probe.touch((String)"http");
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity resEntity = response.getEntity();
            String respStr = EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8");
            EntityUtils.consume((HttpEntity)resEntity);
            if (response.getStatusLine().getStatusCode() == 200) {
                Map<String, String> map = ResolveUtils.resolveJson(respStr);
                return map;
            }
            try {
                throw new KDException(BosErrorCode.uploadFailed, new Object[]{respStr});
            }
            catch (Exception e) {
                log.error((Throwable)e);
                throw new KDException(BosErrorCode.uploadFailed, new Object[]{e.getMessage()});
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
    }

    public static void uploadToFileServer(FileItem item, Map<String, String> headers, String httpUploadUrlPrefix) {
        HashMap<String, String> arg = new HashMap<String, String>();
        arg.put("version", FileServiceVersion.VERSION1.toString());
        arg.put("url", item.getPath());
        arg.put("fileName", item.getFileName());
        arg.put("createNewFileWhenExists", String.valueOf(item.isCreateNewFileWhenExists()));
        if (headers != null) {
            arg.putAll(headers);
        }
        try {
            if (item.getFileName() != null && item.getFileName().indexOf(".") == -1) {
                throw new KDException(BosErrorCode.uploadFailed, new Object[]{"upload file " + item.getPath() + Resources.getString((String)" failed. description: \u6587\u4ef6\u6269\u5c55\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractFileService_0", (String)"bos-fileservice-sdk", (Object[])new Object[0])});
            }
            Map<String, String> result = HttpFileClient.sendFile(httpUploadUrlPrefix, 10000, item.getInputStream(), arg);
            item.close();
            if (result == null) {
                throw new KDException(BosErrorCode.uploadFailed, new Object[]{"upload timeout within 8 seconds" + item.getPath()});
            }
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[]{"upload " + item.getPath() + " failed."});
        }
        finally {
            item.close();
        }
    }

    public static Map<String, Object> getFileStreamAndHeader(String url, int connectionTimeout, int readTimeout, Map<String, String> header) throws KDException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            HashMap<String, String> headerMap;
            CloseableHttpClient client = HttpFileClient.getHttpClient(url);
            HttpGet get = new HttpGet(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectionTimeout).setSocketTimeout(readTimeout).build();
            get.setConfig(requestConfig);
            if (header != null) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    get.setHeader(entry.getKey(), entry.getValue());
                }
            }
            Probe.touch((String)"http");
            HttpResponse response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200) {
                headerMap = new HashMap<String, String>();
                for (Header h : response.getAllHeaders()) {
                    headerMap.put(h.getName(), h.getValue());
                }
            } else {
                HttpEntity resEntity = response.getEntity();
                String respStr = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
                throw new KDException(BosErrorCode.downloadFailed, new Object[]{respStr});
            }
            result.put("INPUT_STREAM", response.getEntity().getContent());
            result.put("header", headerMap);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{url + "error," + e.getMessage()});
        }
        return result;
    }

    public static CloseableHttpClient getHttpClient(String url) {
        int connectTimeout = HttpFileClient.getConnectTimeout();
        int readTimeout = HttpFileClient.getReadTimeout();
        SSLConnectionSocketFactory ssf = HttpFileClient.getSslConnectionSocketFactory(HttpFileClient.getConfigKeyRegion(url));
        CloseableHttpClient client1 = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(connectTimeout).setConnectTimeout(connectTimeout).setSocketTimeout(readTimeout).build()).setSSLSocketFactory((LayeredConnectionSocketFactory)ssf).build();
        return client1;
    }

    private static SSLConnectionSocketFactory getSslConnectionSocketFactory(String keyRegion) {
        SSLConnectionSocketFactory scsf;
        block16: {
            String keystorePath = HttpFileClient.getProperty(FILESERVER_SSL_KEYSTORE_KEY, keyRegion);
            String keystorePass = HttpFileClient.getProperty(FILESERVER_SSL_KEYPASS_KEY, keyRegion);
            boolean sslTrust = StringUtils.isEmpty((String)keystorePath) && StringUtils.isEmpty((String)keystorePass);
            try {
                if (!sslTrust) {
                    KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    try (FileInputStream ins = new FileInputStream(FilenameUtils.normalize((String)keystorePath));){
                        keystorePass = Encrypters.decode((String)keystorePass);
                        trustStore.load(ins, keystorePass.toCharArray());
                    }
                    SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(trustStore, null).build();
                    scsf = new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
                    break block16;
                }
                scsf = new SSLConnectionSocketFactory(SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy()).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                throw new KDException(BosErrorCode.fileserviceException, new Object[]{e});
            }
        }
        return scsf;
    }

    private static String getProperty(String key, String region) {
        String value = System.getProperty(key + "." + region);
        if (StringUtils.isEmpty((String)value)) {
            return System.getProperty(key);
        }
        return value;
    }

    private static String getConfigKeyRegion(String url) {
        String region;
        try {
            URL u = new URL(url);
            String host = u.getHost();
            region = host.replaceAll("\\.", "_");
        }
        catch (Exception e) {
            region = "";
        }
        return region;
    }

    public static CloseableHttpClient getHttpClient(int readTimeOut, String url) {
        int connectTimeout = HttpFileClient.getConnectTimeout();
        if (readTimeOut <= 0) {
            readTimeOut = HttpFileClient.getReadTimeout();
        }
        SSLConnectionSocketFactory ssf = HttpFileClient.getSslConnectionSocketFactory(HttpFileClient.getConfigKeyRegion(url));
        CloseableHttpClient client1 = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(connectTimeout).setConnectTimeout(connectTimeout).setSocketTimeout(readTimeOut).build()).setSSLSocketFactory((LayeredConnectionSocketFactory)ssf).build();
        return client1;
    }

    public static void closeClientAndResponse(CloseableHttpClient client, CloseableHttpResponse response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
        if (client != null) {
            try {
                client.close();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }

    public static int getConnectTimeout() {
        return Integer.parseInt(System.getProperty(FILESERVER_CLIENT_CONNECT_TIMEOUT, "5000"));
    }

    public static int getReadTimeout() {
        return Integer.parseInt(System.getProperty(FILESERVER_CLIENT_READ_TIMEOUT, "10000"));
    }
}

