/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.impl;

import java.net.URI;
import java.net.URLEncoder;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.impl.AbstractFileService;
import kd.bos.fileservice.permission.FilePermissionManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class TempFileService
extends AbstractFileService {
    private static final String FILESERVER_HTTP_URL = "attachmentServer.url";
    private static final String TEMPFILE_UPLOAD_TIMEOUT_S = "tempfile.upload.timeout";
    private static final String TEMPFILE_UPLOAD_MAXSIZE_B = "tempfile.upload.maxsize";
    private static final int DEFAULT_UPLOAD_TIMEOUT = 60;
    private static final int DEFAULT_UPLOAD_MAXSIZE = 0x6400000;

    public TempFileService() {
        super(FILESERVER_HTTP_URL, TempFileService.getUploadTimeout());
    }

    public static int getUploadTimeout() {
        String s = System.getProperty(TEMPFILE_UPLOAD_TIMEOUT_S);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (Exception e) {
                return 60;
            }
        }
        return 60;
    }

    @Override
    public int getMaxUploadSize() {
        String max = System.getProperty(TEMPFILE_UPLOAD_MAXSIZE_B);
        if (max != null) {
            try {
                return Integer.parseInt(max);
            }
            catch (Exception e) {
                return 0x6400000;
            }
        }
        return 0x6400000;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void delete(String path) {
        String httpUrlPrefix = this.getHttpUrlPrefix();
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        try {
            client = this.getHttpClient(this.getConfigKeyRegion(httpUrlPrefix));
            HttpGet get = new HttpGet();
            this.setCookie(get);
            String uri = null;
            path = this.getFileServiceExt().getRealPath(path);
            path = FilePermissionManager.checkDownloadPath(path, this);
            path = URLEncoder.encode(path, "utf-8");
            uri = !httpUrlPrefix.endsWith("/") ? httpUrlPrefix + "/file/remove.do?path=" + path : httpUrlPrefix + "file/remove.do?path=" + path;
            get.setURI(new URI(uri));
            response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() != 200) {
                HttpEntity resEntity = response.getEntity();
                String respStr = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
                throw new KDException(BosErrorCode.deleteFailed, new Object[]{respStr});
            }
            this.getFileServiceExt().afterDeleteFile(path);
        }
        catch (KDException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.deleteFailed, new Object[]{path + "error"});
                }
            }
            catch (Throwable throwable) {
                this.closeClientAndResponse(client, response);
                throw throwable;
            }
        }
        this.closeClientAndResponse(client, response);
    }
}

