/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.enums.PreviewParams;
import kd.bos.fileservice.impl.AbstractFileService;
import kd.bos.fileservice.impl.TimeCachedMap;
import kd.bos.fileservice.spiimpl.FileServiceImpl;
import kd.bos.fileservice.utils.ExceptionUtil;
import kd.bos.fileservice.utils.FileUtil;
import kd.bos.fileservice.utils.HttpClientUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.Pair;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;

public class YunHomeService {
    private static Log logger = LogFactory.getLog(YunHomeService.class);
    private static final String YUN_HOME_SERVER_URL = "yunHome.serverUrl";
    private static final String YUN_HOME_APIGATEWAY_CLIENTID = "yunHome.apiGateway.clientId";
    private static final String YUN_HOME_APIGATEWAY_CLIENT_SECRET = "yunHome.apiGateway.clientSecret";
    private static final String YUN_HOME_APIGATEWAY_TID = "yunHome.apiGateway.tid";
    private static final String YUN_HOME_APIGATEWAY_TID_SERCRET = "yunHome.apiGateway.tidSecret";
    private static final String YUN_HOME_APIGATEWAY_UID = "yunHome.apiGateway.uid";
    private static final String REDIS_ACCESSTOEKN = "yunHome_access_token";
    private static final String REDIS_OPEN_URL = "yunHome_OPEN_URL";
    private static final String TOKEN_SUB = "auth/org/access_token";
    private static final String IMPORT_SUB = "kdrive/wpsouter/yzj/localfile/import";
    private static final String FILEURL_SUB = "kdrive/wpsouter/yzj/file/url";
    private static final String DELETE_SUB = "kdrive/wpsouter/yzj/file/delete";
    private static final String SETSHARE_SUB = "kdrive/wpsouter/yzj/file/setshare";
    private static final String CACHE_PATH_PREFIX = "/yun_home_service/cache/file_id/";
    private static final String CACHE_PATH_SUFFIX = ".txt";
    private static TimeCachedMap<String> cachedMap = new TimeCachedMap(2400);
    private static ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(4);
    private FileService fileService;

    public YunHomeService(FileService fileService) {
        this.fileService = fileService;
    }

    private static boolean isYunHomeEffective(Map<String, String> config) {
        boolean flag = false;
        if (config != null && StringUtils.isNotEmpty((String)config.get(YUN_HOME_SERVER_URL)) && StringUtils.isNotEmpty((String)config.get(YUN_HOME_APIGATEWAY_UID)) && StringUtils.isNotEmpty((String)config.get(YUN_HOME_APIGATEWAY_CLIENTID)) && StringUtils.isNotEmpty((String)config.get(YUN_HOME_APIGATEWAY_CLIENT_SECRET)) && StringUtils.isNotEmpty((String)config.get(YUN_HOME_APIGATEWAY_TID)) && StringUtils.isNotEmpty((String)config.get(YUN_HOME_APIGATEWAY_TID_SERCRET))) {
            String serverUrl = config.get(YUN_HOME_SERVER_URL);
            serverUrl = serverUrl.endsWith("/") ? serverUrl : serverUrl + "/";
            config.put("importUrl", serverUrl + IMPORT_SUB);
            config.put("fileUrl", serverUrl + FILEURL_SUB);
            config.put("deleteUrl", serverUrl + DELETE_SUB);
            config.put("setShareUrl", serverUrl + SETSHARE_SUB);
            config.put("getTokenUrl", serverUrl + TOKEN_SUB + "?client_id=" + config.get(YUN_HOME_APIGATEWAY_CLIENTID) + "&client_secret=" + config.get(YUN_HOME_APIGATEWAY_CLIENT_SECRET) + "&tid=" + config.get(YUN_HOME_APIGATEWAY_TID) + "&secret=" + config.get(YUN_HOME_APIGATEWAY_TID_SERCRET));
            flag = true;
        }
        return flag;
    }

    public static boolean isNotNeedDeal(String suffix) {
        return !"docx".equalsIgnoreCase(suffix) && !"doc".equalsIgnoreCase(suffix) && !"pptx".equalsIgnoreCase(suffix) && !"ppt".equalsIgnoreCase(suffix) && !"xlsx".equalsIgnoreCase(suffix) && !"xls".equalsIgnoreCase(suffix);
    }

    public static Map<String, Object> getNotNeedTransferRs(InputStream cacheIn, String suffix) {
        HashMap<String, Object> rs = new HashMap<String, Object>();
        if (!cacheIn.markSupported()) {
            cacheIn = new BufferedInputStream(cacheIn);
        }
        rs.put(PreviewParams.STATUS.getEnumName(), PreviewParams.NOT_NEED_CHANGE.getEnumName());
        rs.put(PreviewParams.RESULT.getEnumName(), cacheIn);
        if ("txt".equalsIgnoreCase(suffix)) {
            rs.put(PreviewParams.CHARSET.getEnumName(), FileUtil.getFilecharsetNew(cacheIn));
        }
        return rs;
    }

    public Map<String, Object> transferPreviewStream(Map<String, String> config, InputStream cacheIn, String fileName, String savePath) {
        HashMap<String, Object> rs = new HashMap<String, Object>();
        String desc = "";
        if (YunHomeService.isYunHomeEffective(config)) {
            Pair<String, String> accessTokenPair = this.getYunHomeAccessToken(config);
            if (StringUtils.isNotEmpty((String)((String)accessTokenPair.getKey()))) {
                Pair<String, String> fileIdPair = this.yunHomeImport(config, (String)accessTokenPair.getKey(), cacheIn, fileName, savePath);
                if (StringUtils.isNotEmpty((String)((String)fileIdPair.getKey()))) {
                    String fileId = (String)fileIdPair.getKey();
                    Pair<String, String> openUrlPair = YunHomeService.getOpenUrlByFileId(config, (String)accessTokenPair.getKey(), fileId, savePath);
                    if (StringUtils.isNotEmpty((String)((String)openUrlPair.getKey()))) {
                        YunHomeService.setShareReadOnly(config, fileId, (String)accessTokenPair.getKey());
                        rs.put(PreviewParams.STATUS.getEnumName(), PreviewParams.URL.getEnumName());
                        rs.put(PreviewParams.RESULT.getEnumName(), openUrlPair.getKey());
                        return rs;
                    }
                    desc = Resources.getString((String)((String)openUrlPair.getValue()), (String)"YunHomeService_fileId", (String)"bos-fileservice-sdk", (Object[])new Object[0]);
                } else {
                    desc = Resources.getString((String)((String)fileIdPair.getValue()), (String)"YunHomeService_import", (String)"bos-fileservice-sdk", (Object[])new Object[0]);
                }
            } else {
                desc = Resources.getString((String)((String)accessTokenPair.getValue()), (String)"YunHomeService_token", (String)"bos-fileservice-sdk", (Object[])new Object[0]);
            }
        } else {
            desc = Resources.getString((String)"\u7f3a\u5c11\u4e91\u4e4b\u5bb6\u5fc5\u8981\u53c2\u6570\uff1ayunHome.serverUrl  | yunHome.apiGateway.clientId | yunHome.apiGateway.clientSecret |yunHome.apiGateway.uid | yunHome.apiGateway.tid | yunHome.apiGateway.tidSecret", (String)"YunHomeService_config", (String)"bos-fileservice-sdk", (Object[])new Object[0]);
        }
        rs.put(PreviewParams.STATUS.getEnumName(), PreviewParams.ERROR.getEnumName());
        rs.put(PreviewParams.DESCRIPTION.getEnumName(), desc);
        return rs;
    }

    private Pair<String, String> getYunHomeAccessToken(Map<String, String> config) {
        Pair pair = null;
        String rs = "";
        try {
            String accessToken = cachedMap.get(REDIS_ACCESSTOEKN);
            if (StringUtils.isNotEmpty((String)accessToken)) {
                return new Pair((Object)accessToken, null);
            }
            rs = HttpClientUtils.get((String)config.get("getTokenUrl"));
            if (StringUtils.isNotEmpty((String)rs)) {
                JSONObject jsonObject = JSON.parseObject((String)rs);
                if (jsonObject != null && jsonObject.containsKey((Object)"errcode") && "0".equals(jsonObject.getString("errcode")) && StringUtils.isNotEmpty((String)(accessToken = jsonObject.getJSONObject("data").getString("access_token")))) {
                    cachedMap.put(REDIS_ACCESSTOEKN, accessToken);
                    return new Pair((Object)accessToken, null);
                }
                return new Pair(null, (Object)("getYunHomeAccessToken rs:" + rs));
            }
            pair = new Pair(null, (Object)("getYunHomeAccessToken fail rs:" + rs));
        }
        catch (Exception e) {
            logger.error("getYunHomeAccessToken", (Throwable)e);
            pair = new Pair(null, (Object)("getYunHomeAccessToken fail,rs=" + rs + ";[exceptionMsg]:" + ExceptionUtil.toString(e)));
        }
        return pair;
    }

    private Pair<String, String> yunHomeImport(Map<String, String> config, String accessToken, InputStream in, String fileName, String savePath) {
        Pair pair = null;
        String rs = "";
        try {
            String cacheFileId = this.getCacheStringFromFileServer(savePath + CACHE_PATH_SUFFIX);
            if (StringUtils.isNotEmpty((String)cacheFileId)) {
                return new Pair((Object)cacheFileId, null);
            }
            String url = config.get("importUrl") + "?access_token=" + accessToken + "&operator_uid=" + config.get(YUN_HOME_APIGATEWAY_UID);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("operator_tid", config.get(YUN_HOME_APIGATEWAY_TID));
            param.put("file", in);
            param.put("fileFileName&", fileName);
            rs = HttpClientUtil.doPost(url, null, param, null, true, true, System.getProperty("yunHome.timeout"));
            if (StringUtils.isNotEmpty((String)rs)) {
                JSONObject jsonObject = JSON.parseObject((String)rs);
                if (jsonObject != null && jsonObject.containsKey((Object)"errcode") && "0".equals(jsonObject.getString("errcode"))) {
                    String fileId = jsonObject.getJSONObject("data").getString("file_id");
                    this.saveStringToFileServer(fileId, fileName, savePath + CACHE_PATH_SUFFIX);
                    this.scheduleDeleteYZJPreviewCache(config, fileId, savePath + CACHE_PATH_SUFFIX);
                    return new Pair((Object)fileId, null);
                }
                cachedMap.remove(REDIS_ACCESSTOEKN);
            }
            pair = new Pair(null, (Object)("invoke yumHome import interface fail:" + rs));
        }
        catch (Exception e) {
            logger.error("yunHomeImport fail", (Throwable)e);
            pair = new Pair(null, (Object)("yunHomeImport fail,rs=" + rs + ";[exceptionMsg]:" + ExceptionUtil.toString(e)));
        }
        return pair;
    }

    private static Pair<String, String> getOpenUrlByFileId(Map<String, String> config, String accessToken, String fileId, String savePath) {
        Pair pair = null;
        String rs = null;
        try {
            JSONObject jsonObject;
            String cacheOpenUrl = cachedMap.get(REDIS_OPEN_URL + savePath.replace("/", ""));
            if (StringUtils.isNotEmpty((String)cacheOpenUrl)) {
                return new Pair((Object)cacheOpenUrl, null);
            }
            String url = config.get("fileUrl") + "?access_token=" + accessToken;
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", "application/json");
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("operator_uid", Integer.parseInt(config.get(YUN_HOME_APIGATEWAY_UID)));
            param.put("file_id", fileId);
            rs = HttpClientUtils.postAppJson((String)url, header, param);
            if (StringUtils.isNotEmpty((String)rs) && (jsonObject = JSON.parseObject((String)rs)) != null && jsonObject.containsKey((Object)"errcode") && "0".equals(jsonObject.getString("errcode"))) {
                String openUrl = jsonObject.getString("data");
                cachedMap.put(REDIS_OPEN_URL + savePath.replace("/", ""), openUrl);
                return new Pair((Object)openUrl, null);
            }
            pair = new Pair(null, (Object)("invoke file url interface fail,rs=:" + rs));
        }
        catch (Exception e) {
            logger.error("getUrlByFileId error", (Throwable)e);
            pair = new Pair(null, (Object)("getUrlByFileId fail,rs=" + rs + ";[exceptionMsg]:" + ExceptionUtil.toString(e)));
        }
        return pair;
    }

    public static void setShareReadOnly(Map<String, String> config, String fileId, String accessToken) {
        try {
            JSONObject jsonObject;
            String url = config.get("setShareUrl") + "?access_token=" + accessToken;
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", "application/json");
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("enable_share", 1);
            param.put("new_share_range", 1);
            param.put("new_share_permission", "onlyread");
            param.put("file_id", fileId);
            param.put("operator_uid", Integer.parseInt(config.get(YUN_HOME_APIGATEWAY_UID)));
            String rs = HttpClientUtils.postAppJson((String)url, header, param);
            if (StringUtils.isNotEmpty((String)rs) && (jsonObject = JSON.parseObject((String)rs)) != null && jsonObject.containsKey((Object)"errcode") && "0".equals(jsonObject.getString("errcode"))) {
                logger.info("set yzj preview file readonly  success,fileId=" + fileId);
            }
        }
        catch (Exception e) {
            logger.error("deleteFile yzj error", (Throwable)e);
        }
    }

    public static void deleteYunHomeFile(Map<String, String> config, String fileId, String accessToken) {
        try {
            JSONObject jsonObject;
            String url = config.get("deleteUrl") + "?access_token=" + accessToken;
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", "application/json");
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("operator_uid", Integer.parseInt(config.get(YUN_HOME_APIGATEWAY_UID)));
            param.put("pan_file_id", fileId);
            String rs = HttpClientUtils.postAppJson((String)url, header, param);
            if (StringUtils.isNotEmpty((String)rs) && (jsonObject = JSON.parseObject((String)rs)) != null && jsonObject.containsKey((Object)"errcode") && "0".equals(jsonObject.getString("errcode"))) {
                logger.info("delete yzj preview file success,fileId=" + fileId);
            }
        }
        catch (Exception e) {
            logger.error("deleteFile yzj error", (Throwable)e);
        }
    }

    public void deletePrevieCache(Map<String, String> config, String url, boolean needTransfer) {
        if (YunHomeService.isYunHomeEffective(config)) {
            String id = url;
            if (needTransfer) {
                id = YunHomeService.getIdFromTempCachePreviewUrl(url);
            }
            String fileId = this.getCacheStringFromFileServer(id + CACHE_PATH_SUFFIX);
            Pair<String, String> accessTokenPair = this.getYunHomeAccessToken(config);
            if (StringUtils.isNotEmpty((String)fileId) && StringUtils.isNotEmpty((String)((String)accessTokenPair.getKey()))) {
                YunHomeService.deleteYunHomeFile(config, fileId, (String)accessTokenPair.getKey());
                this.deleteCacheFile(id + CACHE_PATH_SUFFIX);
                cachedMap.remove(REDIS_OPEN_URL + id.replace("/", ""));
            }
        } else {
            logger.error("delete fail :\u7f3a\u5c11\u4e91\u4e4b\u5bb6\u5fc5\u8981\u53c2\u6570\uff1ayunHome.serverUrl  | yunHome.apiGateway.clientId | yunHome.apiGateway.clientSecret |yunHome.apiGateway.uid | yunHome.apiGateway.tid | yunHome.apiGateway.tidSecret");
        }
    }

    public void scheduleDeleteYZJPreviewCache(Map<String, String> config, String fileId, String path) {
        scheduledThreadPool.schedule(() -> {
            Pair<String, String> accessTokenPair = this.getYunHomeAccessToken(config);
            if (StringUtils.isNotEmpty((String)((String)accessTokenPair.getKey()))) {
                logger.info("start delete cache preview file in yunhome which dont save in our db");
                this.deleteCacheFile(path);
                YunHomeService.deleteYunHomeFile(config, fileId, (String)accessTokenPair.getKey());
                logger.info("delete cache preview file in yunhome complete");
            }
        }, 2L, TimeUnit.HOURS);
    }

    public static String getIdFromTempCachePreviewUrl(String url) {
        String id = url;
        try {
            String[] pairstr = url.split("\\?");
            String[] pairs = pairstr[1].split("&");
            HashMap<String, String> m = new HashMap<String, String>(pairs.length);
            String[] var5 = pairs;
            int var6 = pairs.length;
            for (int var7 = 0; var7 < var6; ++var7) {
                String pair = var5[var7];
                String[] p = pair.split("=");
                m.put(p[0], p[1]);
            }
            id = CACHE_PATH_PREFIX + (String)m.get("id");
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return id;
    }

    public String getCacheStringFromFileServer(String path) {
        String fileValue = null;
        try (InputStream in = this.fileService.download(path, new HashMap<String, String>(), new HashMap<String, String>());
             ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            if (in != null) {
                byte[] temp = new byte[1024];
                int len = -1;
                while ((len = in.read(temp)) != -1) {
                    byteArrayOutputStream.write(temp, 0, len);
                }
                fileValue = new String(byteArrayOutputStream.toByteArray(), "utf-8");
            }
        }
        catch (Exception e) {
            logger.error("\u4ece\u6587\u4ef6\u670d\u52a1\u5668\u83b7\u53d6\u7f13\u5b58\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return fileValue;
    }

    public void saveStringToFileServer(String cacheValue, String fileName, String path) {
        try {
            ByteArrayInputStream textStream = new ByteArrayInputStream(cacheValue.getBytes("utf-8"));
            FileItem fileItem = new FileItem(fileName, path, textStream);
            this.fileService.upload(fileItem);
            ((InputStream)textStream).close();
        }
        catch (Exception e) {
            logger.error("Save cache file to FileServer error.", (Throwable)e);
        }
    }

    public void deleteCacheFile(String path) {
        try {
            if (this.fileService instanceof AbstractFileService) {
                ((AbstractFileService)this.fileService).physicalDelete(path);
            } else if (this.fileService instanceof FileServiceImpl) {
                ((FileServiceImpl)this.fileService).physicalDelete(path);
            } else {
                this.fileService.delete(path);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }
}

