/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.multiserver;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.impl.HttpFileClient;
import kd.bos.fileservice.multiserver.Dispatcher;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class RoundRobinDispatcher
implements Dispatcher {
    private List<String> servers = new ArrayList<String>(6);
    private Map<String, CloseableHttpClient> serversMap = new ConcurrentHashMap<String, CloseableHttpClient>(6);
    private AtomicInteger atomicIndex = new AtomicInteger(0);
    private static Log logger = LogFactory.getLog(RoundRobinDispatcher.class);
    private final ErrorCode configErrorCode;
    private KDException error;

    public RoundRobinDispatcher(String configKey, ErrorCode configErrorCode) {
        this.init(configKey);
        this.configErrorCode = configErrorCode;
        ConfigurationUtil.observeChange((String)configKey, (key, newValue) -> this.reInit(configKey, false));
    }

    private void init(String configKey) {
        this.reInit(configKey, true);
    }

    private void reInit(String configKey, boolean throwNow) {
        String configValue = System.getProperty(configKey);
        if (StringUtils.isEmpty((String)configValue)) {
            if (throwNow) {
                throw new KDException(this.configErrorCode, new Object[]{"server config " + configKey + " is required"});
            }
            this.error = new KDException(this.configErrorCode, new Object[]{"server config " + configKey + " is required"});
            return;
        }
        this.error = null;
        ArrayList<String> newServers = new ArrayList<String>(6);
        if (configValue.contains("||")) {
            String[] parts;
            for (String part : parts = configValue.split("\\|\\|")) {
                newServers.add(part.trim());
            }
        } else {
            newServers.add(configValue.trim());
        }
        this.servers = newServers;
        newServers.forEach(serverUrl -> this.serversMap.put((String)serverUrl, HttpFileClient.getHttpClient(serverUrl)));
    }

    @Override
    public String select() {
        KDException ex = this.error;
        if (ex != null) {
            throw ex;
        }
        String url = this.getNext();
        int max = this.servers.size();
        int count = 1;
        while (!this.isConnect(url)) {
            if (count >= max) {
                throw new KDException(this.configErrorCode, new Object[]{"The config of server is unavailable!"});
            }
            url = this.getNext();
            ++count;
        }
        return url;
    }

    @Override
    public List<String> getServers() {
        ArrayList<String> serverList = new ArrayList<String>(this.servers.size());
        serverList.addAll(this.servers);
        return serverList;
    }

    private String getNext() {
        int nextIndex;
        int currentIndex;
        while (!this.atomicIndex.compareAndSet(currentIndex, nextIndex = (currentIndex = this.atomicIndex.get()) >= Integer.MAX_VALUE ? 0 : currentIndex + 1)) {
        }
        int index = nextIndex % this.servers.size();
        return this.servers.get(index);
    }

    private boolean isConnect(String uri) {
        CloseableHttpClient client = this.serversMap.get(uri);
        try {
            HttpGet get = new HttpGet();
            get.setURI(new URI(uri));
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            EntityUtils.consume((HttpEntity)response.getEntity());
            return true;
        }
        catch (Exception e) {
            this.reInitClient(uri);
            return this.isConnectExceptInit(uri);
        }
    }

    private boolean isConnectExceptInit(String uri) {
        CloseableHttpClient client = this.serversMap.get(uri);
        try {
            HttpGet get = new HttpGet();
            get.setURI(new URI(uri));
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            EntityUtils.consume((HttpEntity)response.getEntity());
            return true;
        }
        catch (Exception e) {
            logger.error("The server connection is unavailable:" + uri + ":" + e, (Throwable)e);
            return false;
        }
    }

    private synchronized void reInitClient(String uri) {
        this.serversMap.put(uri, HttpFileClient.getHttpClient(uri));
    }
}

