/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.preview;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.preview.PreviewService;
import kd.bos.util.StringUtils;

public class PreviewServiceFactory {
    private static final String ATTACHMENT_FILESTORAGE_CLASSNAME = "attachmentServer.previewImpl.className";

    public static PreviewService getPreviewService(FileService fileService) {
        String previewClassName = System.getProperty(ATTACHMENT_FILESTORAGE_CLASSNAME);
        if (StringUtils.isEmpty((String)previewClassName)) {
            previewClassName = "kd.bos.fileservice.preview.DefaultPreviewServiceImpl";
        }
        PreviewService previewService = PreviewServiceFactory.createByClassName(previewClassName);
        previewService.init(fileService);
        return previewService;
    }

    private static PreviewService createByClassName(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            PreviewService previewService = (PreviewService)clazz.newInstance();
            return previewService;
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.bOSNotImplemented, new Object[]{"Can't create previewService by class:" + className});
        }
    }
}

