/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.recycle;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import kd.bos.fileservice.config.FileServiceConfig;
import kd.bos.fileservice.utils.TAUtil;
import kd.bos.util.StringUtils;

public class RecycleBin {
    public static final String rootPath = "/_RecycleBin_xZtHlXh";
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");

    public static String getRootPath() {
        return rootPath;
    }

    public static String getToday() {
        return dateFormatter.format(LocalDate.now());
    }

    public static String getCurrentDateRecyclePath() {
        return rootPath + RecycleBin.getTenantPath() + "/" + RecycleBin.getToday() + "/" + RecycleBin.randomId();
    }

    private static String getTenantPath() {
        String tenantId = TAUtil.getTenantId();
        if (StringUtils.isEmpty((String)tenantId)) {
            return "/_NoTenant_";
        }
        return "/" + tenantId;
    }

    private static String randomId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static boolean fileServerOpened() {
        return FileServiceConfig.FILE_RECYCLE_BIN_ENABLE.getBoolean();
    }

    public static boolean spiOpened() {
        return FileServiceConfig.FILE_RECYCLE_BIN_SPI_ENABLE.getBoolean();
    }
}

