/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.spiimpl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.utils.TAUtil;
import kd.bos.filestorage.spi.FileStorageConfig;
import kd.bos.filestorage.spi.FileStorageService;
import kd.bos.util.StringUtils;

public class FileStorageSPIFactory {
    private static final Map<String, FileStorageService> fileStorageService = new ConcurrentHashMap<String, FileStorageService>();

    @Deprecated
    public static FileStorageService getFileStorageService(String className) {
        FileStorageService instance = fileStorageService.get(className);
        if (instance == null) {
            if (StringUtils.isEmpty((String)className)) {
                throw new KDException(BosErrorCode.fileServerNotConfigured, new Object[]{"fileStorage.className cannot be empty."});
            }
            instance = FileStorageSPIFactory.createByClassName(className);
            fileStorageService.put(className, instance);
        }
        return instance;
    }

    @Deprecated
    public static FileStorageService getFileStorageService(String fileServiceType, String className) {
        FileStorageService instance = fileStorageService.get(fileServiceType);
        if (instance == null) {
            if (StringUtils.isEmpty((String)className)) {
                throw new KDException(BosErrorCode.fileServerNotConfigured, new Object[]{"fileStorage.className cannot be empty."});
            }
            instance = FileStorageSPIFactory.createByClassName(className);
            fileStorageService.put(fileServiceType, instance);
        }
        return instance;
    }

    public static FileStorageService getFileStorageService(String fileServiceType, String className, FileStorageConfig fileStorageConfig) {
        String accountId = TAUtil.getAccountId();
        String tenantId = TAUtil.getTenantId();
        String key = String.format("%s_%s_%s_%s", accountId, tenantId, fileServiceType, className);
        FileStorageService instance = fileStorageService.get(key);
        if (instance == null) {
            if (StringUtils.isEmpty((String)className)) {
                throw new KDException(BosErrorCode.fileServerNotConfigured, new Object[]{"fileStorage.className cannot be empty."});
            }
            instance = FileStorageSPIFactory.createByClassName(className);
            instance.setConfig(fileStorageConfig);
            fileStorageService.put(key, instance);
        }
        return instance;
    }

    private static FileStorageService createByClassName(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (FileStorageService)clazz.newInstance();
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOSNotImplemented, new Object[]{"Can't create FileStorage by class:" + className});
        }
    }
}

