/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.utils;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import kd.bos.api.Probe;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    private static Log logger = LogFactory.getLog(HttpClientUtil.class);

    public static CloseableHttpClient getCloseableHttpsClients(String timeouts) {
        int timeout = StringUtils.isNotEmpty((String)timeouts) ? Integer.parseInt(timeouts) : 60000;
        try {
            SSLConnectionSocketFactory scsf = new SSLConnectionSocketFactory(SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy()).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).setConnectionRequestTimeout(timeout).build()).setSSLSocketFactory((LayeredConnectionSocketFactory)scsf).build();
            return client;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{e});
        }
    }

    public static String doGet(HttpGet get, Map<String, String> header, String timeout) throws IOException, ParseException {
        HttpClientUtil.assemblyHeaders(get, header);
        return HttpClientUtil.sendRequest((HttpRequestBase)get, timeout);
    }

    public static String doPost(String url, Map<String, String> header, Map<String, Object> postParam, String postBody, boolean isUrlEncodeParam, boolean isMultilData, String timeout) throws IOException, ParseException {
        HttpPost post = new HttpPost(url);
        HttpClientUtil.assemblyHeadersParams(post, header, postParam, postBody, isUrlEncodeParam, isMultilData);
        return HttpClientUtil.sendRequest((HttpRequestBase)post, null, timeout);
    }

    public static String sendRequest(HttpRequestBase method, String timeOut) throws IOException, ParseException {
        return HttpClientUtil.sendRequest(method, null, timeOut);
    }

    public static String sendRequest(HttpRequestBase method, HttpContext httpContext, String timeout) throws IOException, ParseException {
        long starTime = System.currentTimeMillis();
        String ret = null;
        CloseableHttpClient httpClient = HttpClientUtil.getCloseableHttpsClients(timeout);
        try {
            Probe.touch((String)"http");
            HttpResponse httpResponse = null == httpContext ? httpClient.execute((HttpUriRequest)method) : httpClient.execute((HttpUriRequest)method, httpContext);
            HttpEntity entity = httpResponse.getEntity();
            if (200 == httpResponse.getStatusLine().getStatusCode()) {
                if (entity.getContentEncoding() != null && "Content-Encoding: gzip".equalsIgnoreCase(entity.getContentEncoding().toString())) {
                    httpResponse.setEntity((HttpEntity)new GzipDecompressingEntity(httpResponse.getEntity()));
                    entity = httpResponse.getEntity();
                }
            } else {
                logger.error("HttpClient sendRequest \u8bf7\u6c42\u5931\u8d25\uff0c\u72b6\u6001\u7801\uff1a" + httpResponse.getStatusLine().getStatusCode());
            }
            ret = EntityUtils.toString((HttpEntity)entity);
        }
        catch (Exception e) {
            logger.error("HttpClient Request Exception:", (Throwable)e);
            throw e;
        }
        logger.debug("HttpClient \u672c\u6b21\u8bbf\u95ee\u8017\u65f6\uff1a" + (System.currentTimeMillis() - starTime));
        return ret;
    }

    public static void assemblyHeaders(HttpGet get, Map<String, String> header) {
        if (header == null) {
            return;
        }
        for (Map.Entry<String, String> entry : header.entrySet()) {
            get.setHeader(entry.getKey(), entry.getValue());
        }
    }

    public static void assemblyHeadersParams(HttpPost post, Map<String, String> header, Map<String, Object> postParam, String postBody, boolean isFormParam, boolean isMultilData) {
        if (header != null) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                post.setHeader(entry.getKey(), entry.getValue());
            }
        }
        try {
            if (isFormParam) {
                if (!isMultilData) {
                    ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                    if (postParam != null) {
                        for (Map.Entry<String, Object> entry : postParam.entrySet()) {
                            nvps.add(new BasicNameValuePair(entry.getKey(), (String)entry.getValue()));
                        }
                    }
                    post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "utf-8"));
                } else if (postParam != null) {
                    MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                    builder.setCharset(Charset.forName("UTF-8"));
                    builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                    for (Map.Entry<String, Object> entry : postParam.entrySet()) {
                        if (entry.getValue() instanceof InputStream) {
                            String key = entry.getKey();
                            String fileName = (String)postParam.get(key + "FileName&");
                            builder.addBinaryBody(key, (InputStream)entry.getValue(), ContentType.DEFAULT_BINARY, fileName != null ? fileName : "FileName");
                            continue;
                        }
                        if (entry.getKey().endsWith("FileName&")) continue;
                        builder.addTextBody(entry.getKey(), (String)entry.getValue(), ContentType.TEXT_PLAIN);
                    }
                    HttpEntity httpEntity = builder.build();
                    post.setEntity(httpEntity);
                }
            } else {
                StringEntity paramEntity = StringUtils.isEmpty((String)postBody) ? new StringEntity(JSON.toJSONString(postParam)) : new StringEntity(postBody);
                post.setEntity((HttpEntity)paramEntity);
            }
        }
        catch (Exception e) {
            logger.error("post set entity error,exp:", (Throwable)e);
        }
    }
}

