/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.utils;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import kd.bos.fileservice.enums.PreviewParams;
import kd.bos.fileservice.utils.ExceptionUtil;

public class JsonUtil {
    public static Map<String, Object> setSuccessInfo(String url) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(PreviewParams.STATUS.getEnumName(), PreviewParams.SUCCESS.getEnumName());
        result.put(PreviewParams.URL.getEnumName(), url);
        return result;
    }

    public static Map<String, Object> setNotChangeInfo(String msg) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(PreviewParams.STATUS.getEnumName(), PreviewParams.NOT_NEED_CHANGE.getEnumName());
        result.put(PreviewParams.DESCRIPTION.getEnumName(), msg);
        return result;
    }

    public static void writeResponseJson(HttpServletResponse response, CharSequence result) throws IOException {
        response.setContentType("text/json;charset=utf-8");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream((OutputStream)response.getOutputStream()), StandardCharsets.UTF_8.name());){
            writer.write(result.toString());
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeResponseStream(HttpServletResponse response, InputStream in) throws IOException {
        try {
            ServletOutputStream out = response.getOutputStream();
            byte[] buffer = new byte[8192];
            int len = 0;
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            String msg = ExceptionUtil.toString(e);
            if (!msg.contains("Broken pipe")) {
                throw e;
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

