/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.utils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class TAUtil {
    public static final String EMPTY_STR = "";
    private static final Log logger = LogFactory.getLog(TAUtil.class);
    private static Method getOrCreateRequestContext;
    private static Method getAccountId;
    private static Method getTenantId;
    private static Method getAllAccountsOfCurrentEnv;

    public static String getTenantId() {
        try {
            return (String)getTenantId.invoke(getOrCreateRequestContext.invoke(null, new Object[0]), new Object[0]);
        }
        catch (Exception e) {
            return EMPTY_STR;
        }
    }

    public static String getAccountId() {
        try {
            return (String)getAccountId.invoke(getOrCreateRequestContext.invoke(null, new Object[0]), new Object[0]);
        }
        catch (Exception e) {
            return EMPTY_STR;
        }
    }

    public static List<String> getAllTAPrefixList(String splitStr) {
        try {
            List accountList = (List)getAllAccountsOfCurrentEnv.invoke(null, new Object[0]);
            ArrayList<String> taPrefixList = new ArrayList<String>(1);
            for (Object account : accountList) {
                Method[] methods = account.getClass().getMethods();
                StringBuilder taPrefix = new StringBuilder();
                String tenantId = null;
                String accountId = null;
                for (Method getter : methods) {
                    String methodName = getter.getName();
                    if (methodName.equals("getTenantId")) {
                        tenantId = (String)getter.invoke(account, new Object[0]);
                        continue;
                    }
                    if (!methodName.equals("getAccountId")) continue;
                    accountId = (String)getter.invoke(account, new Object[0]);
                }
                taPrefix.append(splitStr).append(tenantId).append(splitStr).append(accountId);
                taPrefixList.add(taPrefix.toString());
            }
            return taPrefixList;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    static {
        try {
            Class<?> cls = Class.forName("kd.bos.context.RequestContext");
            getAccountId = cls.getMethod("getAccountId", new Class[0]);
            getOrCreateRequestContext = cls.getMethod("getOrCreate", new Class[0]);
            getTenantId = cls.getMethod("getTenantId", new Class[0]);
            Class<?> cls1 = Class.forName("kd.bos.dc.utils.AccountUtils");
            getAllAccountsOfCurrentEnv = cls1.getMethod("getAllAccountsOfCurrentEnv", new Class[0]);
        }
        catch (Exception e) {
            logger.warn("FilePathCheckUtil static error.", (Throwable)e);
        }
    }
}

