/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.utils;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Base64;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import kd.bos.bundle.BosRes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class WatermarkUtil {
    public static final String TOP_LEFT = "topLeft";
    public static final String TOP_RIGHT = "topRight";
    public static final String TOP_CENTER = "topCenter";
    public static final String CENTER = "center";
    public static final String CENTER_LEFT = "centerLeft";
    public static final String CENTER_RIGHT = "centerRight";
    public static final String BOTTOM_LEFT = "bottomLeft";
    public static final String BOTTOM_CENTER = "bottomCenter";
    public static final String BOTTOM_RIGHT = "bottomRight";
    private static final int FRAM_WIDTH = 440;
    private static final int FRAME_HEIGHT = 120;
    private static final int FONT_SIZE = 12;
    private static final int ANGLE = -10;
    private static final float ALPHA = 0.1f;
    private static final int X1 = 0;
    private static final int Y1 = 30;
    private static final int X2 = 220;
    private static final int Y2 = 90;
    private static final int MAX_HEIGHT = 30;
    private static final int LIMIT_WATER_IMG_SIZE = 0xA00000;
    private static final int MAX_STR_LENGTH = 150;
    private static Log logger = LogFactory.getLog(WatermarkUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pdfWatermarkTxt(OutputStream warterMarkOut, InputStream pdfStream, String waterMarkName) throws IOException, DocumentException {
        PdfReader reader = null;
        PdfStamper stamper = null;
        try {
            reader = new PdfReader(pdfStream);
            WatermarkUtil.tryDecrypt(reader);
            stamper = new PdfStamper(reader, warterMarkOut);
            JLabel label = new JLabel();
            label.setText(waterMarkName);
            FontMetrics metrics = label.getFontMetrics(label.getFont());
            int textH = metrics.getHeight();
            int textW = metrics.stringWidth(label.getText());
            PdfGState pdfGs = new PdfGState();
            pdfGs.setFillOpacity(0.1f);
            pdfGs.setStrokeOpacity(0.1f);
            BaseFont base = BaseFont.createFont((String)"/resources/SIMHEI.TTF", (String)"Identity-H", (boolean)false);
            int total = reader.getNumberOfPages() + 1;
            for (int i = 1; i < total; ++i) {
                PdfContentByte contentByte = stamper.getOverContent(i);
                contentByte.saveState();
                contentByte.setGState(pdfGs);
                contentByte.beginText();
                contentByte.setFontAndSize(base, 12.0f);
                Rectangle pageSizeWithRotation = reader.getPageSizeWithRotation(i);
                float pageHeight = pageSizeWithRotation.getHeight();
                float pageWidth = pageSizeWithRotation.getWidth();
                int height = textH;
                while ((float)height < pageHeight) {
                    int width = textW;
                    while ((float)width < pageWidth + (float)textW) {
                        contentByte.showTextAligned(0, waterMarkName, (float)(width - textW), (float)(height - textH), 10.0f);
                        width += textW * 2;
                    }
                    height += textH * 3;
                }
                contentByte.endText();
            }
            logger.debug("pdfWatermarkTxt success,txt[{}]", (Object)waterMarkName);
        }
        finally {
            if (stamper != null) {
                try {
                    stamper.close();
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pdfWatermarkImg(OutputStream warterMarkOut, InputStream pdfStream, InputStream imgWarterMarkStream, int rotationDegree) throws IOException, DocumentException {
        PdfReader reader = null;
        PdfStamper stamper = null;
        try {
            if (imgWarterMarkStream.available() > 0xA00000) {
                logger.debug("pdfWatermarkImg imgWatermark size>{}\uff0cend", (Object)0xA00000);
                return;
            }
            reader = new PdfReader(pdfStream);
            WatermarkUtil.tryDecrypt(reader);
            stamper = new PdfStamper(reader, warterMarkOut);
            com.lowagie.text.Image img = com.lowagie.text.Image.getInstance((byte[])WatermarkUtil.getBytes(imgWarterMarkStream));
            if (rotationDegree != 0) {
                img.setRotationDegrees((float)rotationDegree);
            }
            float imgWidth = img.getWidth();
            float imgHeight = img.getHeight();
            float dmarkHeight = imgHeight > 30.0f ? 30.0f : imgHeight;
            float dmarkWidth = dmarkHeight / imgHeight * imgWidth;
            img.scaleAbsolute(dmarkWidth, dmarkHeight);
            PdfGState gs = new PdfGState();
            gs.setFillOpacity(0.1f);
            gs.setStrokeOpacity(0.1f);
            int total = reader.getNumberOfPages() + 1;
            for (int i = 1; i < total; ++i) {
                PdfContentByte content = stamper.getOverContent(i);
                content.saveState();
                content.setGState(gs);
                Rectangle pageSizeWithRotation = reader.getPageSizeWithRotation(i);
                float pageHeight = pageSizeWithRotation.getHeight();
                float pageWidth = pageSizeWithRotation.getWidth();
                for (float height = dmarkHeight; height < pageHeight; height += dmarkHeight * 3.0f) {
                    for (float width = dmarkWidth; width < pageWidth + dmarkWidth; width += dmarkWidth * 2.0f) {
                        img.setAbsolutePosition(width, height);
                        content.addImage(img);
                    }
                }
            }
            logger.debug("pdfWatermarkImg success");
        }
        finally {
            if (stamper != null) {
                try {
                    stamper.close();
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pdfWatermarkUpImgUnderTxt(OutputStream warterMarkOut, InputStream pdfStream, InputStream imgwatermarkstream, String waterMarkName) throws IOException, DocumentException {
        PdfReader pdfReader = null;
        PdfStamper stamper = null;
        try {
            if (imgwatermarkstream.available() > 0xA00000) {
                logger.debug("pdfWatermarkUpImgUnderTxt imgWatermark size>{}\uff0cend", (Object)0xA00000);
                return;
            }
            pdfReader = new PdfReader(pdfStream);
            WatermarkUtil.tryDecrypt(pdfReader);
            stamper = new PdfStamper(pdfReader, warterMarkOut);
            com.lowagie.text.Image img = com.lowagie.text.Image.getInstance((byte[])WatermarkUtil.getBytes(imgwatermarkstream));
            img.setRotationDegrees(10.0f);
            float imgWidth = img.getWidth();
            float imgHeight = img.getHeight();
            float dmarkHeight = imgHeight > 30.0f ? 30.0f : imgHeight;
            float dmarkWidth = dmarkHeight / imgHeight * imgWidth;
            img.scaleAbsolute(dmarkWidth, dmarkHeight);
            JLabel label = new JLabel();
            label.setText(waterMarkName);
            FontMetrics metrics = label.getFontMetrics(label.getFont());
            int textH = metrics.getHeight();
            int textW = metrics.stringWidth(label.getText());
            PdfGState gState = new PdfGState();
            gState.setFillOpacity(0.1f);
            gState.setStrokeOpacity(0.1f);
            BaseFont base = BaseFont.createFont((String)"/resources/SIMHEI.TTF", (String)"Identity-H", (boolean)false);
            int total = pdfReader.getNumberOfPages() + 1;
            for (int i = 1; i < total; ++i) {
                float mergeWidth;
                PdfContentByte content = stamper.getOverContent(i);
                content.saveState();
                content.setGState(gState);
                content.beginText();
                content.setFontAndSize(base, 12.0f);
                Rectangle pageSizeWithRotation = pdfReader.getPageSizeWithRotation(i);
                float pageHeight = pageSizeWithRotation.getHeight();
                float pageWidth = pageSizeWithRotation.getWidth();
                float mergeHeight = (float)textH + dmarkHeight + 5.0f;
                for (float height = mergeWidth = (float)textW - dmarkWidth > 0.0f ? (float)textW : dmarkWidth; height < pageHeight; height += mergeHeight * 3.0f) {
                    for (float width = mergeWidth; width < pageWidth + (float)textW; width += mergeWidth * 2.0f) {
                        img.setAbsolutePosition(width - mergeWidth, height - dmarkHeight);
                        content.addImage(img);
                        content.showTextAligned(0, waterMarkName, width - mergeWidth, height - mergeHeight, 10.0f);
                    }
                }
                content.endText();
            }
            logger.debug("pdfWatermarkUpImgUnderTxt success,txt[{}],img size[{}]", (Object)waterMarkName, (Object)imgwatermarkstream.available());
        }
        finally {
            if (stamper != null) {
                try {
                    stamper.close();
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
            if (pdfReader != null) {
                pdfReader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pdfWatermarkLeftImgRightTxt(OutputStream warterMarkOut, InputStream pdfStream, InputStream imgwatermarkstream, String waterMarkName) throws IOException, DocumentException {
        PdfReader reader = null;
        PdfStamper stamper = null;
        try {
            if (imgwatermarkstream.available() > 0xA00000) {
                logger.debug("pdfWatermarkLeftImgRightTxt imgWatermark size>{}\uff0cend", (Object)0xA00000);
                return;
            }
            reader = new PdfReader(pdfStream);
            WatermarkUtil.tryDecrypt(reader);
            stamper = new PdfStamper(reader, warterMarkOut);
            com.lowagie.text.Image img = com.lowagie.text.Image.getInstance((byte[])WatermarkUtil.getBytes(imgwatermarkstream));
            img.setRotationDegrees(10.0f);
            float imgWidth = img.getWidth();
            float imgHeight = img.getHeight();
            float dmarkHeight = imgHeight > 30.0f ? 30.0f : imgHeight;
            float dmarkWidth = dmarkHeight / imgHeight * imgWidth;
            img.scaleAbsolute(dmarkWidth, dmarkHeight);
            JLabel label = new JLabel();
            label.setText(waterMarkName);
            FontMetrics metrics = label.getFontMetrics(label.getFont());
            int textH = metrics.getHeight();
            int textW = metrics.stringWidth(label.getText());
            PdfGState gs = new PdfGState();
            gs.setFillOpacity(0.1f);
            gs.setStrokeOpacity(0.1f);
            BaseFont baseFont = BaseFont.createFont((String)"/resources/SIMHEI.TTF", (String)"Identity-H", (boolean)false);
            int total = reader.getNumberOfPages() + 1;
            for (int i = 1; i < total; ++i) {
                PdfContentByte pdfContentByte = stamper.getOverContent(i);
                pdfContentByte.saveState();
                pdfContentByte.setGState(gs);
                pdfContentByte.beginText();
                pdfContentByte.setFontAndSize(baseFont, 12.0f);
                Rectangle pageSizeWithRotation = reader.getPageSizeWithRotation(i);
                float pageHeight = pageSizeWithRotation.getHeight();
                float pageWidth = pageSizeWithRotation.getWidth();
                float mergeHeight = (float)textH - dmarkHeight > 0.0f ? (float)textH : dmarkHeight;
                float mergeWidth = (float)textW + dmarkWidth + 5.0f;
                for (float height = mergeHeight; height < pageHeight; height += mergeHeight * 3.0f) {
                    for (float width = mergeWidth; width < pageWidth + (float)textW; width += mergeWidth * 2.0f) {
                        img.setAbsolutePosition(width - mergeWidth, height - mergeHeight);
                        pdfContentByte.addImage(img);
                        pdfContentByte.showTextAligned(0, waterMarkName, width - (float)textW, height - mergeHeight + 15.0f, 10.0f);
                    }
                }
                pdfContentByte.endText();
            }
            logger.debug("pdfWatermarkLeftImgRightTxt success,txt[{}],img size[{}]", (Object)waterMarkName, (Object)imgwatermarkstream.available());
        }
        finally {
            if (stamper != null) {
                try {
                    stamper.close();
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static void imgWatermarkTxt(OutputStream out, InputStream srcImgStream, Color markContentColor, String waterMarkContent, String watermarkPosition) throws IOException {
        int y;
        int x;
        BufferedImage srcBufferedImg = ImageIO.read(srcImgStream);
        int srcWidthNum = srcBufferedImg.getWidth(null);
        int srcHeightNum = srcBufferedImg.getHeight(null);
        BufferedImage bufImg = new BufferedImage(srcWidthNum, srcHeightNum, 1);
        Graphics2D g = bufImg.createGraphics();
        g.drawImage(srcBufferedImg, 0, 0, srcWidthNum, srcHeightNum, null);
        g.setComposite(AlphaComposite.getInstance(10, 0.1f));
        Font font = new Font(BosRes.get((String)"bos-fileservice-sdk", (String)"WatermarkUtil_0", (String)"\u5b8b\u4f53", (Object[])new Object[0]), 0, 12);
        g.setColor(markContentColor);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setFont(font);
        JLabel label = new JLabel();
        label.setText(waterMarkContent);
        FontMetrics metrics = label.getFontMetrics(label.getFont());
        int imarkHeight = metrics.getHeight();
        int imarkWidth = g.getFontMetrics(g.getFont()).charsWidth(waterMarkContent.toCharArray(), 0, waterMarkContent.length());
        switch (watermarkPosition) {
            case "topLeft": {
                x = 0;
                y = imarkHeight;
                break;
            }
            case "topRight": {
                x = srcWidthNum - imarkWidth;
                y = imarkHeight;
                break;
            }
            case "topCenter": {
                x = (srcWidthNum - imarkWidth) / 2;
                y = imarkHeight;
                break;
            }
            case "center": {
                x = (srcWidthNum - imarkWidth) / 2;
                y = (srcHeightNum - imarkHeight) / 2;
                break;
            }
            case "centerLeft": {
                x = 0;
                y = (srcHeightNum - imarkHeight) / 2;
                break;
            }
            case "centerRight": {
                x = srcWidthNum - imarkWidth;
                y = (srcHeightNum - imarkHeight) / 2;
                break;
            }
            case "bottomLeft": {
                x = 0;
                y = srcHeightNum - imarkHeight;
                break;
            }
            case "bottomCenter": {
                x = (srcWidthNum - imarkWidth) / 2;
                y = srcHeightNum - imarkHeight;
                break;
            }
            case "bottomRight": {
                x = srcWidthNum - imarkWidth;
                y = srcHeightNum - imarkHeight;
                break;
            }
            default: {
                x = -1;
                y = -1;
            }
        }
        if (x == -1 && y == -1) {
            for (int y1 = 0; y1 < srcHeightNum; y1 += imarkHeight * 5) {
                for (int x1 = 0; x1 < srcWidthNum; x1 += imarkWidth * 3) {
                    g.drawString(waterMarkContent, x1, y1);
                }
            }
        } else {
            g.drawString(waterMarkContent, x, y);
        }
        g.dispose();
        ImageIO.write((RenderedImage)bufImg, "png", out);
        logger.debug("imgWatermarkTxt success,txt[{}] watermarkPosition [{}]", (Object)waterMarkContent, (Object)watermarkPosition);
    }

    public static void imgWatermarkImg(OutputStream outStream, InputStream srcImgStream, InputStream iconStream, String watermarkPosition) throws IOException {
        int y;
        int x;
        if (iconStream.available() > 0xA00000) {
            logger.debug("imgWatermarkImg imgWatermark size>{}\uff0cend", (Object)0xA00000);
            return;
        }
        BufferedImage srcImg = ImageIO.read(srcImgStream);
        BufferedImage buffImg = new BufferedImage(srcImg.getWidth(null), srcImg.getHeight(null), 1);
        int srcWidth = srcImg.getWidth(null);
        int srcHeight = srcImg.getHeight(null);
        Graphics2D g = buffImg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(srcImg.getScaledInstance(srcImg.getWidth(null), srcImg.getHeight(null), 4), 0, 0, null);
        g.setComposite(AlphaComposite.getInstance(10, 0.1f));
        ImageIcon imgIcon = new ImageIcon(WatermarkUtil.getBytes(iconStream));
        Image img = imgIcon.getImage();
        int watermarkImageWidth = img.getWidth(null);
        int watermarkImageHeight = img.getHeight(null);
        double dmarkWidth = 50.0;
        double dmarkHeight = dmarkWidth * ((double)watermarkImageHeight / (double)watermarkImageWidth);
        int imarkWidth = (int)dmarkWidth;
        int imarkHeight = (int)dmarkHeight;
        switch (watermarkPosition) {
            case "topLeft": {
                x = 0;
                y = 0;
                break;
            }
            case "topRight": {
                x = srcWidth - imarkWidth;
                y = 0;
                break;
            }
            case "topCenter": {
                x = (srcWidth - imarkWidth) / 2;
                y = 0;
                break;
            }
            case "center": {
                x = (srcWidth - imarkWidth) / 2;
                y = (srcHeight - imarkHeight) / 2;
                break;
            }
            case "centerLeft": {
                x = 0;
                y = (srcHeight - imarkHeight) / 2;
                break;
            }
            case "centerRight": {
                x = srcWidth - imarkWidth;
                y = (srcHeight - imarkHeight) / 2;
                break;
            }
            case "bottomLeft": {
                x = 0;
                y = srcHeight - imarkHeight;
                break;
            }
            case "bottomCenter": {
                x = (srcWidth - imarkWidth) / 2;
                y = srcHeight - imarkHeight;
                break;
            }
            case "bottomRight": {
                x = srcWidth - imarkWidth;
                y = srcHeight - imarkHeight;
                break;
            }
            default: {
                x = -1;
                y = -1;
            }
        }
        if (x == -1 && y == -1) {
            for (int y1 = 0; y1 < srcHeight; y1 += imarkHeight * 3) {
                for (int x1 = 0; x1 < srcWidth; x1 += imarkWidth * 3) {
                    g.drawImage(img, x1, y1, imarkWidth, imarkHeight, null);
                }
            }
        } else {
            g.drawImage(img, x, y, imarkWidth, imarkHeight, null);
        }
        g.setComposite(AlphaComposite.getInstance(3));
        g.dispose();
        ImageIO.write((RenderedImage)buffImg, "png", outStream);
        logger.debug("imgWatermarkImg success,img size[{}] watermarkPosition [{}]", (Object)iconStream.available(), (Object)watermarkPosition);
    }

    public static void imgWatermarkUpImgUnderTxt(OutputStream out, InputStream srcImgStream, InputStream watermarkImg, Color markContentColor, String waterMarkContent, String watermarkPosition) throws IOException {
        if (watermarkImg.available() > 0xA00000) {
            logger.debug("imgWatermarkUpImgUnderTxt imgWatermark size>{}\uff0cend", (Object)0xA00000);
            return;
        }
        BufferedImage srcImg = ImageIO.read(srcImgStream);
        int srcWidth = srcImg.getWidth(null);
        int srcHeight = srcImg.getHeight(null);
        BufferedImage bufImg = new BufferedImage(srcWidth, srcHeight, 1);
        Graphics2D g = bufImg.createGraphics();
        g.drawImage(srcImg, 0, 0, srcWidth, srcHeight, null);
        Font font = new Font(BosRes.get((String)"bos-fileservice-sdk", (String)"WatermarkUtil_0", (String)"\u5b8b\u4f53", (Object[])new Object[0]), 0, 12);
        g.setColor(markContentColor);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setComposite(AlphaComposite.getInstance(10, 0.1f));
        g.setFont(font);
        JLabel label = new JLabel();
        label.setText(waterMarkContent);
        FontMetrics metrics = label.getFontMetrics(label.getFont());
        int textMarkHeight = metrics.getHeight();
        int textMarkWidth = g.getFontMetrics(g.getFont()).charsWidth(waterMarkContent.toCharArray(), 0, waterMarkContent.length());
        ImageIcon imgIcon = new ImageIcon(WatermarkUtil.getBytes(watermarkImg));
        Image img = imgIcon.getImage();
        int watermarkImageWidth = img.getWidth(null);
        int watermarkImageHeight = img.getHeight(null);
        double dmarkWidth = 50.0;
        double dmarkHeight = dmarkWidth * ((double)watermarkImageHeight / (double)watermarkImageWidth);
        int imgMarkWidth = (int)dmarkWidth;
        int imgMarkHeight = (int)dmarkHeight;
        int widthLongOne = textMarkWidth >= imgMarkWidth ? textMarkWidth : imgMarkWidth;
        int totalHeght = textMarkHeight + imgMarkHeight + 5;
        switch (watermarkPosition) {
            case "topLeft": {
                g.drawImage(img, 0, 0, imgMarkWidth, imgMarkHeight, null);
                g.drawString(waterMarkContent, 0, imgMarkHeight + 5);
                break;
            }
            case "topRight": {
                g.drawImage(img, srcWidth - widthLongOne, 0, imgMarkWidth, imgMarkHeight, null);
                g.drawString(waterMarkContent, srcWidth - widthLongOne, imgMarkHeight + 5);
                break;
            }
            case "topCenter": {
                g.drawImage(img, (srcWidth - widthLongOne) / 2, 0, imgMarkWidth, imgMarkHeight, null);
                g.drawString(waterMarkContent, (srcWidth - widthLongOne) / 2, imgMarkHeight + 5);
                break;
            }
            case "center": {
                g.drawImage(img, (srcWidth - widthLongOne) / 2, (srcHeight - totalHeght) / 2, imgMarkWidth, imgMarkHeight, null);
                g.drawString(waterMarkContent, (srcWidth - widthLongOne) / 2, (srcHeight - totalHeght) / 2 + imgMarkHeight + 5);
                break;
            }
            case "centerLeft": {
                g.drawImage(img, 0, (srcHeight - totalHeght) / 2, imgMarkWidth, imgMarkHeight, null);
                g.drawString(waterMarkContent, 0, (srcHeight - totalHeght) / 2 + imgMarkHeight + 5);
                break;
            }
            case "centerRight": {
                g.drawImage(img, srcWidth - widthLongOne, (srcHeight - totalHeght) / 2, imgMarkWidth, imgMarkHeight, null);
                g.drawString(waterMarkContent, srcWidth - widthLongOne, (srcHeight - totalHeght) / 2 + imgMarkHeight + 5);
                break;
            }
            case "bottomLeft": {
                g.drawImage(img, 0, srcHeight - totalHeght, imgMarkWidth, imgMarkHeight, null);
                g.drawString(waterMarkContent, 0, srcHeight - textMarkHeight);
                break;
            }
            case "bottomCenter": {
                g.drawImage(img, (srcWidth - widthLongOne) / 2, srcHeight - totalHeght, imgMarkWidth, imgMarkHeight, null);
                g.drawString(waterMarkContent, (srcWidth - widthLongOne) / 2, srcHeight - textMarkHeight);
                break;
            }
            case "bottomRight": {
                g.drawImage(img, srcWidth - widthLongOne, srcHeight - totalHeght, imgMarkWidth, imgMarkHeight, null);
                g.drawString(waterMarkContent, srcWidth - widthLongOne, srcHeight - textMarkHeight);
                break;
            }
            default: {
                for (int y = 0; y < srcHeight; y += totalHeght * 3) {
                    for (int x = 0; x < srcWidth; x += widthLongOne * 2) {
                        g.drawImage(img, x, y, imgMarkWidth, imgMarkHeight, null);
                        g.drawString(waterMarkContent, x, y + imgMarkHeight + 15);
                    }
                }
            }
        }
        g.dispose();
        ImageIO.write((RenderedImage)bufImg, "png", out);
        logger.debug("imgWatermarkUpImgUnderTxt success,text [{}] ,img size[{}] ,watermarkPosition [{}]", new Object[]{waterMarkContent, watermarkImg.available(), watermarkPosition});
    }

    public static void imgWatermarkLeftImgRightTxt(OutputStream out, InputStream srcImgStream, InputStream watermarkImg, Color markContentColor, String waterMarkContent, String watermarkPosition) throws IOException {
        if (watermarkImg.available() > 0xA00000) {
            logger.debug("imgWatermarkLeftImgRightTxt imgWatermark size>{}\uff0cend", (Object)0xA00000);
            return;
        }
        BufferedImage srcImgBuf = ImageIO.read(srcImgStream);
        int srcWidth = srcImgBuf.getWidth(null);
        int srcHeight = srcImgBuf.getHeight(null);
        BufferedImage bufImg = new BufferedImage(srcWidth, srcHeight, 1);
        Graphics2D g = bufImg.createGraphics();
        g.drawImage(srcImgBuf, 0, 0, srcWidth, srcHeight, null);
        Font font = new Font(BosRes.get((String)"bos-fileservice-sdk", (String)"WatermarkUtil_0", (String)"\u5b8b\u4f53", (Object[])new Object[0]), 0, 12);
        g.setColor(markContentColor);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setComposite(AlphaComposite.getInstance(10, 0.1f));
        g.setFont(font);
        JLabel label = new JLabel();
        label.setText(waterMarkContent);
        FontMetrics metrics = label.getFontMetrics(label.getFont());
        int textMarkHeight = metrics.getHeight();
        int textMarkWidth = g.getFontMetrics(g.getFont()).charsWidth(waterMarkContent.toCharArray(), 0, waterMarkContent.length());
        ImageIcon imgIcon = new ImageIcon(WatermarkUtil.getBytes(watermarkImg));
        Image img = imgIcon.getImage();
        int watermarkImageWidth = img.getWidth(null);
        int watermarkImageHeight = img.getHeight(null);
        double dmarkWidth = 50.0;
        double dmarkHeight = dmarkWidth * ((double)watermarkImageHeight / (double)watermarkImageWidth);
        int imgMarkWidth = (int)dmarkWidth;
        int imgMarkHeight = (int)dmarkHeight;
        int heightLongOne = textMarkHeight >= imgMarkHeight ? textMarkHeight : imgMarkHeight;
        int totalWight = textMarkWidth + imgMarkWidth + 5;
        switch (watermarkPosition) {
            case "topLeft": {
                g.drawImage(img, 0, 0, imgMarkWidth, imgMarkHeight, null);
                g.drawString(waterMarkContent, imgMarkWidth + 5, imgMarkHeight - textMarkHeight);
                break;
            }
            case "topRight": {
                g.drawImage(img, srcWidth - totalWight, 0, imgMarkWidth, imgMarkHeight, null);
                g.drawString(waterMarkContent, srcWidth - totalWight + imgMarkWidth + 5, imgMarkHeight - textMarkHeight);
                break;
            }
            case "topCenter": {
                g.drawImage(img, (srcWidth - totalWight) / 2, 0, imgMarkWidth, imgMarkHeight, null);
                g.drawString(waterMarkContent, (srcWidth - totalWight) / 2 + imgMarkWidth + 5, imgMarkHeight - textMarkHeight);
                break;
            }
            case "center": {
                g.drawImage(img, (srcWidth - totalWight) / 2, (srcHeight - heightLongOne) / 2, imgMarkWidth, imgMarkHeight, null);
                g.drawString(waterMarkContent, (srcWidth - totalWight) / 2 + imgMarkWidth + 5, (srcHeight - heightLongOne) / 2 + imgMarkHeight - textMarkHeight);
                break;
            }
            case "centerLeft": {
                g.drawImage(img, 0, (srcHeight - heightLongOne) / 2, imgMarkWidth, imgMarkHeight, null);
                g.drawString(waterMarkContent, imgMarkWidth + 5, (srcHeight - heightLongOne) / 2 + imgMarkHeight - textMarkHeight);
                break;
            }
            case "centerRight": {
                g.drawImage(img, srcWidth - totalWight, (srcHeight - heightLongOne) / 2, imgMarkWidth, imgMarkHeight, null);
                g.drawString(waterMarkContent, srcWidth - totalWight + imgMarkWidth + 5, (srcHeight - heightLongOne) / 2 + imgMarkHeight - textMarkHeight);
                break;
            }
            case "bottomLeft": {
                g.drawImage(img, 0, srcHeight - heightLongOne, imgMarkWidth, imgMarkHeight, null);
                g.drawString(waterMarkContent, imgMarkWidth + 5, srcHeight - heightLongOne + imgMarkHeight - textMarkHeight);
                break;
            }
            case "bottomCenter": {
                g.drawImage(img, (srcWidth - totalWight) / 2, srcHeight - heightLongOne, imgMarkWidth, imgMarkHeight, null);
                g.drawString(waterMarkContent, (srcWidth - totalWight) / 2 + imgMarkWidth + 5, srcHeight - heightLongOne + imgMarkHeight - textMarkHeight);
                break;
            }
            case "bottomRight": {
                g.drawImage(img, srcWidth - totalWight, srcHeight - heightLongOne, imgMarkWidth, imgMarkHeight, null);
                g.drawString(waterMarkContent, srcWidth - totalWight + imgMarkWidth + 5, srcHeight - heightLongOne + imgMarkHeight - textMarkHeight);
                break;
            }
            default: {
                for (int y = 0; y < srcHeight; y += heightLongOne * 3) {
                    for (int x = 0; x < srcWidth; x += totalWight * 2) {
                        g.drawImage(img, x, y, imgMarkWidth, imgMarkHeight, null);
                        g.drawString(waterMarkContent, x + imgMarkWidth + 5, y + imgMarkHeight / 2 + 5);
                    }
                }
            }
        }
        g.dispose();
        ImageIO.write((RenderedImage)bufImg, "png", out);
        logger.debug("imgWatermarkLeftImgRightTxt success,text [{}] ,img size[{}] ,watermarkPosition [{}]", new Object[]{waterMarkContent, watermarkImg.available(), watermarkPosition});
    }

    public static InputStream text2Pdf(InputStream textStream, String charsetName) throws IOException, DocumentException {
        String str;
        long start = System.currentTimeMillis();
        ByteArrayInputStream pdfStream = null;
        ByteArrayOutputStream pdfOut = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A2);
        PdfWriter.getInstance((Document)document, (OutputStream)pdfOut);
        document.open();
        BaseFont baseFont = BaseFont.createFont((String)"/resources/SIMHEI.TTF", (String)"Identity-H", (boolean)false);
        com.lowagie.text.Font FontChinese = new com.lowagie.text.Font(baseFont, 12.0f);
        Paragraph paragraph = new Paragraph();
        paragraph.setFont(FontChinese);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(textStream, StringUtils.isEmpty((String)charsetName) ? "GBK" : charsetName));
        while ((str = bufferedReader.readLine()) != null) {
            for (int i = 0; i < str.length(); i += 150) {
                int end = i + 150 <= str.length() ? i + 150 : str.length();
                paragraph.add(str.substring(i, end).replaceAll("\t", "        ") + "\n");
            }
        }
        document.add((Element)paragraph);
        bufferedReader.close();
        document.close();
        pdfStream = new ByteArrayInputStream(pdfOut.toByteArray());
        pdfOut.close();
        logger.debug("text2Pdf success;cost time:" + (System.currentTimeMillis() - start));
        return pdfStream;
    }

    public static String iconHtmlStr(InputStream inputStream) throws IOException {
        if (inputStream.available() > 0xA00000) {
            logger.debug("htmlWatermark imgWatermark size>{}\uff0cend", (Object)0xA00000);
            return "";
        }
        byte[] iconBytes = WatermarkUtil.getBytes(inputStream);
        String iconStr = Base64.getEncoder().encodeToString(iconBytes);
        return WatermarkUtil.getJsCode(iconStr);
    }

    private static String getJsCode(String iconStr) {
        return "<script language=\"JavaScript\">\n   \t  document.addEventListener('DOMContentLoaded', function() {\n   \t   var body =document.body;\n   \t   if(body.length!=0){\n   \t    var scrollWidth=document.documentElement.scrollWidth;\n   \t   \tvar scrollHeight=document.documentElement.scrollHeight;\n   \t   \t\n   \t   \tvar clientWidth=document.documentElement.clientWidth;\n   \t   \tvar clientHeight=document.documentElement.clientHeight;\n   \t   \t\n   \t   \tvar height=clientHeight;\n   \t   \tvar width=clientWidth;\n   \t   \tif(scrollHeight>clientHeight){\n   \t   \t\theight=scrollHeight;\n   \t   \t}\n   \t   \tif(scrollWidth>clientWidth){\n   \t   \t\twidth=scrollWidth\n   \t   \t}\n   \t   \tvar node = document.createElement(\"div\");\n       node.setAttribute(\"style\",\"background-image: url(data:image/png;base64," + iconStr.replaceAll("\\s", "") + ");\\n\" +\n                \"\\twidth: \"+width+\"px;\\n\" +\n                \"\\theight: \"+height+\"px;\\n\" +\n                \"\\tposition: absolute;\\n\" +\n                \"\\ttop: 0;\\n\" +\n                \"\\tpointer-events: none;\\n\" +\n                \"\\topacity: 1;\");\n        body.appendChild(node);\n   \t   }\n   \t });</script>";
    }

    public static void drawImageTxt(OutputStream out, String text) throws IOException {
        BufferedImage bufImg = new BufferedImage(440, 120, 2);
        Graphics2D g = bufImg.createGraphics();
        Font font = new Font(null, 0, 12);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setColor(Color.BLACK);
        g.setFont(font);
        g.rotate(Math.toRadians(-10.0), 110.0, 30.0);
        g.drawString(text, 0, 30);
        g.drawString(text, 220, 90);
        g.dispose();
        ImageIO.write((RenderedImage)bufImg, "png", out);
        logger.debug("drawImageTxt success text [{}]", (Object)text);
    }

    public static void drawImageImg(OutputStream out, InputStream icon) throws IOException {
        BufferedImage srcImg = ImageIO.read(icon);
        int iconWidth = srcImg.getWidth(null);
        int iconHeight = srcImg.getHeight(null);
        BufferedImage bufImg = new BufferedImage(440, 120, 2);
        Graphics2D g = bufImg.createGraphics();
        Font font = new Font(BosRes.get((String)"bos-fileservice-sdk", (String)"WatermarkUtil_1", (String)"\u9ed1\u4f53", (Object[])new Object[0]), 0, 12);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setColor(Color.BLACK);
        g.setFont(font);
        g.rotate(Math.toRadians(-10.0), 110.0, 30.0);
        if (iconHeight > 30) {
            int width = 30 * iconWidth / iconHeight;
            g.drawImage(srcImg, 0, 30, width, 30, null);
            g.drawImage(srcImg, 220, 90, width, 30, null);
        } else {
            g.drawImage((Image)srcImg, 0, 30, null);
            g.drawImage((Image)srcImg, 220, 90, null);
        }
        g.dispose();
        ImageIO.write((RenderedImage)bufImg, "png", out);
        logger.debug("drawImageImg success img size [{}]", (Object)icon.available());
    }

    public static void drawImageUpImgUnderTxt(OutputStream out, InputStream icon, String text) throws IOException {
        BufferedImage srcImg = ImageIO.read(icon);
        int iconWidth = srcImg.getWidth(null);
        int iconHeight = srcImg.getHeight(null);
        BufferedImage bufImg = new BufferedImage(440, 120, 2);
        Graphics2D g = bufImg.createGraphics();
        Font font = new Font(BosRes.get((String)"bos-fileservice-sdk", (String)"WatermarkUtil_1", (String)"\u9ed1\u4f53", (Object[])new Object[0]), 0, 12);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setColor(Color.BLACK);
        g.setFont(font);
        g.rotate(Math.toRadians(-10.0), 110.0, 30.0);
        if (iconHeight > 30) {
            int width = 30 * iconWidth / iconHeight;
            g.drawImage(srcImg, 0, 30, width, 30, null);
            g.drawString(text, 0, 75);
            g.drawImage(srcImg, 220, 90, width, 30, null);
            g.drawString(text, 220, 135);
        } else {
            g.drawImage((Image)srcImg, 0, 30, null);
            g.drawString(text, 0, 30 + iconHeight + 5);
            g.drawImage((Image)srcImg, 220, 90, null);
            g.drawString(text, 220, 90 + iconHeight + 5);
        }
        g.dispose();
        ImageIO.write((RenderedImage)bufImg, "png", out);
        logger.debug("drawImageUpImgUnderTxt success text [{}] ,img size [{}]", (Object)text, (Object)icon.available());
    }

    public static void drawImageLeftImgRightTxt(OutputStream out, InputStream icon, String text) throws IOException {
        BufferedImage srcImg = ImageIO.read(icon);
        int iconWidth = srcImg.getWidth(null);
        int iconHeight = srcImg.getHeight(null);
        BufferedImage bufImg = new BufferedImage(440, 120, 2);
        Graphics2D g = bufImg.createGraphics();
        Font font = new Font(BosRes.get((String)"bos-fileservice-sdk", (String)"WatermarkUtil_1", (String)"\u9ed1\u4f53", (Object[])new Object[0]), 0, 12);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setColor(Color.BLACK);
        g.setFont(font);
        g.rotate(Math.toRadians(-10.0), 110.0, 30.0);
        if (iconHeight > 30) {
            int width = 30 * iconWidth / iconHeight;
            g.drawImage(srcImg, 0, 30, width, 30, null);
            g.drawString(text, 0 + width + 5, 45);
            g.drawImage(srcImg, 220, 90, width, 30, null);
            g.drawString(text, 220 + width + 5, 105);
        } else {
            g.drawImage((Image)srcImg, 0, 30, null);
            g.drawString(text, 0 + iconWidth + 5, 40);
            g.drawImage((Image)srcImg, 220, 90, null);
            g.drawString(text, 220 + iconWidth + 5, 100);
        }
        g.dispose();
        ImageIO.write((RenderedImage)bufImg, "png", out);
        logger.debug("drawImageLeftImgRightTxt success text [{}] ,img size [{}]", (Object)text, (Object)icon.available());
    }

    private static byte[] getBytes(InputStream in) throws IOException {
        byte[] bytes = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int i = -1;
        byte[] buf = new byte[1024];
        while ((i = in.read(buf)) != -1) {
            byteArrayOutputStream.write(buf, 0, i);
        }
        bytes = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        in.close();
        return bytes;
    }

    private static void tryDecrypt(PdfReader reader) throws DocumentException {
        if (reader.isEncrypted()) {
            try {
                Field ownerPasswordUsed = PdfReader.class.getDeclaredField("ownerPasswordUsed");
                ownerPasswordUsed.setAccessible(true);
                ownerPasswordUsed.setBoolean(reader, true);
            }
            catch (NoSuchFieldException e) {
                throw new DocumentException((Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new DocumentException((Exception)e);
            }
        }
    }
}

