/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.watermark;

import java.awt.AlphaComposite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import kd.bos.fileservice.enums.WatermarkType;
import kd.bos.fileservice.watermark.IWatermarkHandler;
import kd.bos.fileservice.watermark.WatermarkParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ExcelWatermarkHandler
implements IWatermarkHandler {
    private static Log logger = LogFactory.getLog(ExcelWatermarkHandler.class);
    private static Font font;

    @Override
    public InputStream watermark(Map<String, Object> params, InputStream origin, WatermarkParameter watermarkParameter) throws IOException {
        ByteArrayInputStream in = null;
        Integer type = watermarkParameter.getType();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (WatermarkType.TEXT.ordinal() == type.intValue()) {
            this.drawWatermarkTxt(outputStream, watermarkParameter);
        } else if (WatermarkType.IMG.ordinal() == type.intValue()) {
            this.drawWatermarkImg(outputStream, watermarkParameter);
        } else if (WatermarkType.UP_IMG_UNDER_TEXT.ordinal() == type.intValue()) {
            this.drawWatermarkUpImgUnderTxt(outputStream, watermarkParameter);
        } else if (WatermarkType.LEFT_IMG_RIGHT_TEXT.ordinal() == type.intValue()) {
            this.drawWatermarkLeftImgRightTxt(outputStream, watermarkParameter);
        }
        if (outputStream.size() != 0) {
            in = new ByteArrayInputStream(outputStream.toByteArray());
        }
        return in;
    }

    private void drawWatermarkTxt(OutputStream outputStream, WatermarkParameter watermarkParameter) throws IOException {
        String s;
        int i;
        long startTime = System.currentTimeMillis();
        int frameWidth = watermarkParameter.getStyle().getFrameWidth();
        int frameHeight = watermarkParameter.getStyle().getFrameHeight();
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        int X2 = watermarkParameter.getStyle().getX2();
        int Y2 = watermarkParameter.getStyle().getY2();
        String text = watermarkParameter.getText();
        if (text == null || text.equals("")) {
            return;
        }
        String[] texts = this.splitNewline(text);
        int fontSize = watermarkParameter.getSize();
        BufferedImage bufImg = new BufferedImage(frameWidth, frameHeight, 2);
        Graphics2D g = bufImg.createGraphics();
        this.initGraphics(g, watermarkParameter);
        for (i = 0; i < texts.length; ++i) {
            s = texts[i];
            g.drawString(s, X1, Y1 + i * fontSize);
        }
        this.reRotateGraphics(g, watermarkParameter);
        for (i = 0; i < texts.length; ++i) {
            s = texts[i];
            g.drawString(s, X2, Y2 + i * fontSize);
        }
        g.dispose();
        ImageIO.write((RenderedImage)bufImg, "png", outputStream);
        logger.debug("cost: " + (System.currentTimeMillis() - startTime) + " ms");
    }

    private void drawWatermarkImg(OutputStream outputStream, WatermarkParameter watermarkParameter) throws IOException {
        long startTime = System.currentTimeMillis();
        int frameWidth = watermarkParameter.getStyle().getFrameWidth();
        int frameHeight = watermarkParameter.getStyle().getFrameHeight();
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        int X2 = watermarkParameter.getStyle().getX2();
        int Y2 = watermarkParameter.getStyle().getY2();
        BufferedImage srcImg = ImageIO.read(watermarkParameter.getImage());
        int iconWidth = srcImg.getWidth(null);
        int iconHeight = srcImg.getHeight(null);
        BufferedImage bufImg = new BufferedImage(frameWidth, frameHeight, 2);
        Graphics2D g = bufImg.createGraphics();
        this.initGraphics(g, watermarkParameter);
        if (iconHeight > 30) {
            int width = 30 * iconWidth / iconHeight;
            g.drawImage(srcImg, X1, Y1, width, 30, null);
            this.reRotateGraphics(g, watermarkParameter);
            g.drawImage(srcImg, X2, Y2, width, 30, null);
        } else {
            g.drawImage((Image)srcImg, X1, Y1, null);
            this.reRotateGraphics(g, watermarkParameter);
            g.drawImage((Image)srcImg, X2, Y2, null);
        }
        g.dispose();
        ImageIO.write((RenderedImage)bufImg, "png", outputStream);
        logger.debug("cost: " + (System.currentTimeMillis() - startTime) + " ms");
    }

    private void drawWatermarkUpImgUnderTxt(OutputStream outputStream, WatermarkParameter watermarkParameter) throws IOException {
        long startTime = System.currentTimeMillis();
        int frameWidth = watermarkParameter.getStyle().getFrameWidth();
        int frameHeight = watermarkParameter.getStyle().getFrameHeight();
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        int X2 = watermarkParameter.getStyle().getX2();
        int Y2 = watermarkParameter.getStyle().getY2();
        String txtWatermark = watermarkParameter.getText();
        if (txtWatermark == null || txtWatermark.equals("")) {
            return;
        }
        String[] texts = this.splitNewline(txtWatermark);
        int fontSize = watermarkParameter.getSize();
        BufferedImage srcImg = ImageIO.read(watermarkParameter.getImage());
        int iconWidth = srcImg.getWidth(null);
        int iconHeight = srcImg.getHeight(null);
        BufferedImage bufImg = new BufferedImage(frameWidth, frameHeight, 2);
        Graphics2D g = bufImg.createGraphics();
        this.initGraphics(g, watermarkParameter);
        if (iconHeight > 30) {
            String s;
            int i;
            int width = 30 * iconWidth / iconHeight;
            g.drawImage(srcImg, X1, Y1, width, 30, null);
            for (i = 0; i < texts.length; ++i) {
                s = texts[i];
                g.drawString(s, X1, Y1 + 30 + 15 + i * fontSize);
            }
            this.reRotateGraphics(g, watermarkParameter);
            g.drawImage(srcImg, X2, Y2, width, 30, null);
            for (i = 0; i < texts.length; ++i) {
                s = texts[i];
                g.drawString(s, X2, Y2 + 30 + 15 + i * fontSize);
            }
        } else {
            String s;
            int i;
            g.drawImage((Image)srcImg, X1, Y1, null);
            for (i = 0; i < texts.length; ++i) {
                s = texts[i];
                g.drawString(s, X1, Y1 + iconHeight + 10 + i * fontSize);
            }
            this.reRotateGraphics(g, watermarkParameter);
            g.drawImage((Image)srcImg, X2, Y2, null);
            for (i = 0; i < texts.length; ++i) {
                s = texts[i];
                g.drawString(s, X2, Y2 + iconHeight + 10 + i * fontSize);
            }
        }
        g.dispose();
        ImageIO.write((RenderedImage)bufImg, "png", outputStream);
        logger.debug("cost: " + (System.currentTimeMillis() - startTime) + " ms");
    }

    private void drawWatermarkLeftImgRightTxt(OutputStream outputStream, WatermarkParameter watermarkParameter) throws IOException {
        long startTime = System.currentTimeMillis();
        int frameWidth = watermarkParameter.getStyle().getFrameWidth();
        int frameHeight = watermarkParameter.getStyle().getFrameHeight();
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        int X2 = watermarkParameter.getStyle().getX2();
        int Y2 = watermarkParameter.getStyle().getY2();
        String txtWatermark = watermarkParameter.getText();
        if (txtWatermark == null || txtWatermark.equals("")) {
            return;
        }
        String[] texts = this.splitNewline(txtWatermark);
        int fontSize = watermarkParameter.getSize();
        int newLineCenterOffset = (int)((double)(texts.length - 2) * 0.5 * (double)fontSize);
        BufferedImage srcImg = ImageIO.read(watermarkParameter.getImage());
        int iconWidth = srcImg.getWidth(null);
        int iconHeight = srcImg.getHeight(null);
        BufferedImage bufImg = new BufferedImage(frameWidth, frameHeight, 2);
        Graphics2D g = bufImg.createGraphics();
        this.initGraphics(g, watermarkParameter);
        if (iconHeight > 30) {
            int width = 30 * iconWidth / iconHeight;
            g.drawImage(srcImg, X1, Y1, width, 30, null);
            int x = X1 + width + 5;
            int y = Y1 + 15 - fontSize / 2 - newLineCenterOffset;
            for (int i = 0; i < texts.length; ++i) {
                String s = texts[i];
                g.drawString(s, x, y + i * fontSize);
            }
            this.reRotateGraphics(g, watermarkParameter);
            g.drawImage(srcImg, X2, Y2, width, 30, null);
            int x2 = X2 + width + 5;
            int y2 = Y2 + 15 - fontSize / 2 - newLineCenterOffset;
            for (int i = 0; i < texts.length; ++i) {
                String s = texts[i];
                g.drawString(s, x2, y2 + i * fontSize);
            }
        } else {
            g.drawImage((Image)srcImg, X1, Y1, null);
            int x = X1 + iconWidth + 5;
            int y = Y1 + iconHeight / 2 - fontSize / 2 - newLineCenterOffset;
            for (int i = 0; i < texts.length; ++i) {
                String s = texts[i];
                g.drawString(s, x, y + i * fontSize);
            }
            this.reRotateGraphics(g, watermarkParameter);
            g.drawImage((Image)srcImg, X2, Y2, null);
            int x2 = X2 + iconWidth + 5;
            int y2 = Y2 + iconHeight / 2 - fontSize / 2 - newLineCenterOffset;
            for (int i = 0; i < texts.length; ++i) {
                String s = texts[i];
                g.drawString(s, x2, y2 + i * fontSize);
            }
        }
        g.dispose();
        ImageIO.write((RenderedImage)bufImg, "png", outputStream);
        logger.debug("cost: " + (System.currentTimeMillis() - startTime) + " ms");
    }

    private void initGraphics(Graphics2D g, WatermarkParameter watermarkParameter) {
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        if (font != null) {
            g.setFont(font.deriveFont(0, watermarkParameter.getSize().intValue()));
        }
        g.setColor(watermarkParameter.getColor());
        g.rotate(Math.toRadians(-watermarkParameter.getRotation().intValue()), X1, Y1);
        g.setComposite(AlphaComposite.getInstance(11, watermarkParameter.getAlpha().floatValue()));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    private void reRotateGraphics(Graphics2D g, WatermarkParameter watermarkParameter) {
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        int X2 = watermarkParameter.getStyle().getX2();
        int Y2 = watermarkParameter.getStyle().getY2();
        g.rotate(Math.toRadians(watermarkParameter.getRotation().intValue()), X1, Y1);
        g.rotate(Math.toRadians(-watermarkParameter.getRotation().intValue()), X2, Y2);
    }

    static {
        try (InputStream stream = ExcelWatermarkHandler.class.getResourceAsStream("/resources/SIMHEI.TTF");){
            font = Font.createFont(0, stream);
        }
        catch (Exception e) {
            logger.error("create font failed. ", (Throwable)e);
        }
    }
}

