/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.watermark;

import com.lowagie.text.DocumentException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import kd.bos.fileservice.enums.WatermarkType;
import kd.bos.fileservice.utils.FileTimeoutUtil;
import kd.bos.fileservice.watermark.WatermarkParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.FileUtils;

public interface IWatermarkHandler {
    public static final Log logger = LogFactory.getLog(IWatermarkHandler.class);
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    public static final String NEWLINE_CHAR = "/n";
    public static final String NEWLINE_CHAR_1 = "\n";
    public static final String NEWLINE_CHAR_2 = "\r\n";
    public static final String TOP_LEFT = "topLeft";
    public static final String TOP_RIGHT = "topRight";
    public static final String TOP_CENTER = "topCenter";
    public static final String CENTER = "center";
    public static final String CENTER_LEFT = "centerLeft";
    public static final String CENTER_RIGHT = "centerRight";
    public static final String BOTTOM_LEFT = "bottomLeft";
    public static final String BOTTOM_CENTER = "bottomCenter";
    public static final String BOTTOM_RIGHT = "bottomRight";
    public static final int FRAME_WIDTH = 440;
    public static final int FRAME_HEIGHT = 120;
    public static final int X1 = 0;
    public static final int Y1 = 30;
    public static final int X2 = 220;
    public static final int Y2 = 90;
    public static final int MAX_HEIGHT = 30;
    public static final int LIMIT_WATER_IMG_SIZE = 0xA00000;
    public static final int MAX_STR_LENGTH = 150;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public InputStream watermark(Map<String, Object> params, InputStream origin, WatermarkParameter watermarkParameter) throws IOException, DocumentException {
        FileInputStream watermarked = null;
        if (origin != null) {
            long startTime = System.currentTimeMillis();
            String watermarkFilepath = FileUtils.checkFileUrl((String)(TEMP_DIR + "/WATERMARK" + UUID.randomUUID().toString().replace("-", "")));
            FileTimeoutUtil.removeFile(watermarkFilepath, null, 120000L);
            FileOutputStream out = new FileOutputStream(watermarkFilepath);
            Integer type = watermarkParameter.getType();
            try {
                if (WatermarkType.TEXT.ordinal() == type.intValue()) {
                    this.watermarkTxt(out, origin, watermarkParameter);
                } else if (WatermarkType.IMG.ordinal() == type.intValue()) {
                    this.watermarkImg(out, origin, watermarkParameter);
                } else if (WatermarkType.UP_IMG_UNDER_TEXT.ordinal() == type.intValue()) {
                    this.watermarkUpImgUnderTxt(out, origin, watermarkParameter);
                } else if (WatermarkType.LEFT_IMG_RIGHT_TEXT.ordinal() == type.intValue()) {
                    this.watermarkLeftImgRightTxt(out, origin, watermarkParameter);
                }
            }
            finally {
                logger.debug("watermark and write temp file cost: " + (System.currentTimeMillis() - startTime) + "ms");
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            watermarked = new FileInputStream(watermarkFilepath);
        }
        return watermarked;
    }

    default public void watermarkTxt(OutputStream outputStream, InputStream origin, WatermarkParameter watermarkParameter) throws IOException, DocumentException {
    }

    default public void watermarkImg(OutputStream outputStream, InputStream origin, WatermarkParameter watermarkParameter) throws IOException, DocumentException {
    }

    default public void watermarkUpImgUnderTxt(OutputStream outputStream, InputStream origin, WatermarkParameter watermarkParameter) throws IOException, DocumentException {
    }

    default public void watermarkLeftImgRightTxt(OutputStream outputStream, InputStream origin, WatermarkParameter watermarkParameter) throws IOException, DocumentException {
    }

    default public String[] splitNewline(String text) {
        if (text == null || text.isEmpty()) {
            return new String[0];
        }
        text = text.replace(NEWLINE_CHAR_2, NEWLINE_CHAR).replace(NEWLINE_CHAR_1, NEWLINE_CHAR);
        return text.split(NEWLINE_CHAR);
    }
}

