/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.watermark;

import com.lowagie.text.DocumentException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kd.bos.fileservice.watermark.IWatermarkHandler;
import kd.bos.fileservice.watermark.PdfWatermarkHandler;
import kd.bos.fileservice.watermark.WatermarkParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;
import org.jetbrains.annotations.NotNull;

public class PdfWatermarkHandler2
implements IWatermarkHandler {
    private static final Log logger = LogFactory.getLog(PdfWatermarkHandler.class);
    private static String fontPath = "/resources/SIMHEI.TTF";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watermarkTxt(OutputStream outputStream, InputStream origin, WatermarkParameter watermark) throws IOException, DocumentException {
        long startTime = System.currentTimeMillis();
        try (PDDocument document = null;){
            document = PDDocument.load((InputStream)origin);
            PDType0Font font = PDType0Font.load((PDDocument)document, (InputStream)PdfWatermarkHandler2.class.getResourceAsStream(fontPath));
            for (PDPage page : document.getPages()) {
                float pageH = page.getMediaBox().getHeight();
                float pageW = page.getMediaBox().getWidth();
                PDPageContentStream pageContent = PdfWatermarkHandler2.getPdPageContentStream(watermark, document, page, (PDFont)font);
                this.showText(watermark, pageContent, pageW, pageH);
            }
            document.save(outputStream);
            logger.debug("cost: " + (System.currentTimeMillis() - startTime) + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watermarkImg(OutputStream outputStream, InputStream origin, WatermarkParameter watermark) throws IOException, DocumentException {
        long startTime = System.currentTimeMillis();
        InputStream imgWarterMarkStream = watermark.getImage();
        byte[] imgBytes = IOUtils.toByteArray((InputStream)imgWarterMarkStream);
        try (PDDocument document = null;){
            if (imgBytes.length > 0xA00000) {
                logger.warn("img size={}, greater than limit size[{}], do nothing", (Object)imgBytes.length, (Object)0xA00000);
                return;
            }
            document = PDDocument.load((InputStream)origin);
            PDImageXObject image = PDImageXObject.createFromByteArray((PDDocument)document, (byte[])imgBytes, (String)"png");
            for (PDPage page : document.getPages()) {
                float pageH = page.getMediaBox().getHeight();
                float pageW = page.getMediaBox().getWidth();
                PDPageContentStream pageContent = PdfWatermarkHandler2.getPdPageContentStream(watermark, document, page, null);
                this.showImage(watermark, pageContent, pageW, pageH, image);
            }
            document.save(outputStream);
            logger.debug("cost: " + (System.currentTimeMillis() - startTime) + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watermarkUpImgUnderTxt(OutputStream outputStream, InputStream origin, WatermarkParameter watermark) throws IOException, DocumentException {
        long startTime = System.currentTimeMillis();
        InputStream in = watermark.getImage();
        byte[] imgBytes = IOUtils.toByteArray((InputStream)in);
        try (PDDocument document = null;){
            if (imgBytes.length > 0xA00000) {
                logger.warn("img size={}, greater than limit size[{}], do nothing", (Object)imgBytes.length, (Object)0xA00000);
                return;
            }
            document = PDDocument.load((InputStream)origin);
            PDType0Font font = PDType0Font.load((PDDocument)document, (InputStream)PdfWatermarkHandler2.class.getResourceAsStream(fontPath));
            PDImageXObject image = PDImageXObject.createFromByteArray((PDDocument)document, (byte[])imgBytes, (String)"png");
            for (PDPage page : document.getPages()) {
                float pageH = page.getMediaBox().getHeight();
                float pageW = page.getMediaBox().getWidth();
                PDPageContentStream pageContent = PdfWatermarkHandler2.getPdPageContentStream(watermark, document, page, (PDFont)font);
                this.showUpImgUnderTxt(watermark, pageContent, pageW, pageH, image);
                pageContent.restoreGraphicsState();
                pageContent.close();
            }
            document.save(outputStream);
            logger.debug("cost: " + (System.currentTimeMillis() - startTime) + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watermarkLeftImgRightTxt(OutputStream outputStream, InputStream origin, WatermarkParameter watermark) throws IOException, DocumentException {
        long startTime = System.currentTimeMillis();
        InputStream in = watermark.getImage();
        byte[] imgBytes = IOUtils.toByteArray((InputStream)in);
        try (PDDocument document = null;){
            if (imgBytes.length > 0xA00000) {
                logger.warn("img size={}, greater than limit size[{}], do nothing", (Object)imgBytes.length, (Object)0xA00000);
                return;
            }
            document = PDDocument.load((InputStream)origin);
            PDType0Font font = PDType0Font.load((PDDocument)document, (InputStream)PdfWatermarkHandler2.class.getResourceAsStream(fontPath));
            PDImageXObject image = PDImageXObject.createFromByteArray((PDDocument)document, (byte[])imgBytes, (String)"png");
            for (PDPage page : document.getPages()) {
                float pageH = page.getMediaBox().getHeight();
                float pageW = page.getMediaBox().getWidth();
                PDPageContentStream pageContent = PdfWatermarkHandler2.getPdPageContentStream(watermark, document, page, (PDFont)font);
                this.showLeftImgRightTxt(watermark, pageContent, pageW, pageH, image);
                pageContent.restoreGraphicsState();
                pageContent.close();
            }
            document.save(outputStream);
            logger.debug("cost: " + (System.currentTimeMillis() - startTime) + " ms");
        }
    }

    private void showText(WatermarkParameter watermark, PDPageContentStream pageContent, float pageW, float pageH) throws IOException {
        String[] texts = this.splitNewline(watermark.getText());
        double theta = Math.toRadians(watermark.getRotation().intValue());
        int frameWidth = watermark.getStyle().getFrameWidth();
        int frameHeight = watermark.getStyle().getFrameHeight();
        int X1 = watermark.getStyle().getX1();
        int Y1 = watermark.getStyle().getY1();
        int X2 = watermark.getStyle().getX2();
        int Y2 = watermark.getStyle().getY2();
        pageContent.beginText();
        int x = 0;
        while ((float)x < pageW) {
            int y = 0;
            while ((float)y < pageH) {
                this.showTextNewLine(pageContent, texts, theta, x, y, watermark.getSize());
                this.showTextNewLine(pageContent, texts, theta, x + (X2 - X1), y + (Y2 - Y1), watermark.getSize());
                y += frameHeight;
            }
            x += frameWidth;
        }
        pageContent.endText();
        pageContent.restoreGraphicsState();
        pageContent.close();
    }

    private void showImage(WatermarkParameter watermark, PDPageContentStream pageContent, float pageW, float pageH, PDImageXObject image) throws IOException {
        double theta = Math.toRadians(watermark.getRotation().intValue());
        double reverseTheta = Math.toRadians(-watermark.getRotation().intValue());
        int frameWidth = watermark.getStyle().getFrameWidth();
        int frameHeight = watermark.getStyle().getFrameHeight();
        int X1 = watermark.getStyle().getX1();
        int Y1 = watermark.getStyle().getY1();
        int X2 = watermark.getStyle().getX2();
        int Y2 = watermark.getStyle().getY2();
        float imageH = Math.min(image.getHeight(), 30);
        float imageW = imageH / (float)image.getHeight() * (float)image.getWidth();
        pageContent.transform(Matrix.getRotateInstance((double)theta, (float)0.0f, (float)0.0f));
        int x = 0;
        while ((float)x < pageW) {
            int y = 0;
            while ((float)y < pageH) {
                pageContent.drawImage(image, this.computeX(reverseTheta, x, y), this.computeY(reverseTheta, x, y), imageW, imageH);
                pageContent.drawImage(image, this.computeX(reverseTheta, x + (X2 - X1), y + (Y2 - Y1)), this.computeY(reverseTheta, x + (X2 - X1), y + (Y2 - Y1)), imageW, imageH);
                y += frameHeight;
            }
            x += frameWidth;
        }
        pageContent.restoreGraphicsState();
        pageContent.close();
    }

    private void showUpImgUnderTxt(WatermarkParameter watermark, PDPageContentStream pageContent, float pageW, float pageH, PDImageXObject image) throws IOException {
        String[] texts = this.splitNewline(watermark.getText());
        double theta = Math.toRadians(watermark.getRotation().intValue());
        double reverseTheta = Math.toRadians(-watermark.getRotation().intValue());
        int frameWidth = watermark.getStyle().getFrameWidth();
        int frameHeight = watermark.getStyle().getFrameHeight();
        int X1 = watermark.getStyle().getX1();
        int Y1 = watermark.getStyle().getY1();
        int X2 = watermark.getStyle().getX2();
        int Y2 = watermark.getStyle().getY2();
        float imageH = Math.min(image.getHeight(), 30);
        float imageW = imageH / (float)image.getHeight() * (float)image.getWidth();
        int textH = watermark.getSize();
        pageContent.transform(Matrix.getRotateInstance((double)theta, (float)0.0f, (float)0.0f));
        int i = 0;
        while ((float)i < pageW) {
            int j = 0;
            while ((float)j < pageH) {
                float x = this.computeX(reverseTheta, i, j);
                float y = this.computeY(reverseTheta, i, j);
                pageContent.drawImage(image, x, y, imageW, imageH);
                pageContent.beginText();
                this.showTextNewLine(pageContent, texts, 0.0, x, y - (float)textH, watermark.getSize());
                pageContent.endText();
                x = this.computeX(reverseTheta, i + (X2 - X1), j + (Y2 - Y1));
                y = this.computeY(reverseTheta, i + (X2 - X1), j + (Y2 - Y1));
                pageContent.drawImage(image, x, y, imageW, imageH);
                pageContent.beginText();
                this.showTextNewLine(pageContent, texts, 0.0, x, y - (float)textH, watermark.getSize());
                pageContent.endText();
                j += frameHeight;
            }
            i += frameWidth;
        }
        pageContent.transform(Matrix.getRotateInstance((double)reverseTheta, (float)0.0f, (float)0.0f));
    }

    private void showLeftImgRightTxt(WatermarkParameter watermark, PDPageContentStream pageContent, float pageW, float pageH, PDImageXObject image) throws IOException {
        String[] texts = this.splitNewline(watermark.getText());
        double theta = Math.toRadians(watermark.getRotation().intValue());
        double reverseTheta = Math.toRadians(-watermark.getRotation().intValue());
        int frameWidth = watermark.getStyle().getFrameWidth();
        int frameHeight = watermark.getStyle().getFrameHeight();
        int X1 = watermark.getStyle().getX1();
        int Y1 = watermark.getStyle().getY1();
        int X2 = watermark.getStyle().getX2();
        int Y2 = watermark.getStyle().getY2();
        float imageH = Math.min(image.getHeight(), 30);
        float imageW = imageH / (float)image.getHeight() * (float)image.getWidth();
        int textH = texts.length * watermark.getSize();
        pageContent.transform(Matrix.getRotateInstance((double)theta, (float)0.0f, (float)0.0f));
        int i = 0;
        while ((float)i < pageW) {
            int j = 0;
            while ((float)j < pageH) {
                float x = this.computeX(reverseTheta, i, j);
                float y = this.computeY(reverseTheta, i, j);
                pageContent.drawImage(image, x, y, imageW, imageH);
                pageContent.beginText();
                this.showTextNewLine(pageContent, texts, 0.0, x + imageW, y + Math.max(imageH, (float)textH) / 2.0f, watermark.getSize());
                pageContent.endText();
                x = this.computeX(reverseTheta, i + (X2 - X1), j + (Y2 - Y1));
                y = this.computeY(reverseTheta, i + (X2 - X1), j + (Y2 - Y1));
                pageContent.drawImage(image, x, y, imageW, imageH);
                pageContent.beginText();
                this.showTextNewLine(pageContent, texts, 0.0, x + imageW, y + Math.max(imageH, (float)textH) / 2.0f, watermark.getSize());
                pageContent.endText();
                j += frameHeight;
            }
            i += frameWidth;
        }
        pageContent.transform(Matrix.getRotateInstance((double)reverseTheta, (float)0.0f, (float)0.0f));
    }

    private void showTextNewLine(PDPageContentStream pageContent, String[] texts, double theta, float x, float y, int fontSize) throws IOException {
        pageContent.setTextMatrix(Matrix.getRotateInstance((double)theta, (float)x, (float)y));
        for (String text : texts) {
            pageContent.showText(text);
            pageContent.newLineAtOffset(0.0f, (float)(-fontSize));
        }
    }

    @NotNull
    private static PDPageContentStream getPdPageContentStream(WatermarkParameter watermark, PDDocument document, PDPage page, PDFont font) throws IOException {
        PDPageContentStream content = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);
        PDExtendedGraphicsState graph = new PDExtendedGraphicsState();
        graph.setNonStrokingAlphaConstant(watermark.getAlpha());
        graph.setAlphaSourceFlag(true);
        content.setGraphicsStateParameters(graph);
        if (font != null) {
            content.setNonStrokingColor(watermark.getColor().getRed(), watermark.getColor().getGreen(), watermark.getColor().getBlue());
            content.setFont(font, (float)watermark.getSize().intValue());
        }
        return content;
    }

    private float computeX(double theta, int x, int y) {
        return (float)((double)x * Math.cos(theta) - (double)y * Math.sin(theta));
    }

    private float computeY(double theta, int x, int y) {
        return (float)((double)x * Math.sin(theta) + (double)y * Math.cos(theta));
    }
}

