/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.watermark;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfWriter;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import kd.bos.fileservice.enums.PreviewParams;
import kd.bos.fileservice.utils.FileTimeoutUtil;
import kd.bos.fileservice.watermark.IWatermarkHandler;
import kd.bos.fileservice.watermark.WatermarkHandlerFactory;
import kd.bos.fileservice.watermark.WatermarkParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.FileUtils;
import kd.bos.util.StringUtils;

public class TxtWatermarkHandler
implements IWatermarkHandler {
    private static Log logger = LogFactory.getLog(TxtWatermarkHandler.class);

    @Override
    public InputStream watermark(Map<String, Object> params, InputStream origin, WatermarkParameter watermarkParameter) throws IOException, DocumentException {
        String charset = (String)params.get(PreviewParams.CHARSET.getEnumName());
        InputStream watermarked = null;
        if (origin != null) {
            InputStream pdf = TxtWatermarkHandler.text2Pdf(origin, charset);
            watermarked = WatermarkHandlerFactory.getHandler("pdf").watermark(params, pdf, watermarkParameter);
        }
        return watermarked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream text2Pdf(InputStream textStream, String charsetName) throws IOException, DocumentException {
        long start = System.currentTimeMillis();
        String tempFilePath = FileUtils.checkFileUrl((String)(TEMP_DIR + "trans2PDF" + UUID.randomUUID().toString().replace("-", "")));
        FileOutputStream pdfOut = null;
        BufferedReader bufferedReader = null;
        Document document = null;
        try {
            String str;
            pdfOut = new FileOutputStream(tempFilePath);
            FileTimeoutUtil.removeFile(tempFilePath, null, 120000L);
            document = new Document(PageSize.A2);
            PdfWriter.getInstance((Document)document, (OutputStream)pdfOut);
            document.open();
            BaseFont baseFont = BaseFont.createFont((String)"/resources/SIMHEI.TTF", (String)"Identity-H", (boolean)false);
            Font FontChinese = new Font(baseFont, 12.0f);
            Paragraph paragraph = new Paragraph();
            paragraph.setFont(FontChinese);
            bufferedReader = new BufferedReader(new InputStreamReader(textStream, StringUtils.isEmpty((String)charsetName) ? "GBK" : charsetName));
            while ((str = bufferedReader.readLine()) != null) {
                for (int i = 0; i < str.length(); i += 150) {
                    int end = i + 150 <= str.length() ? i + 150 : str.length();
                    paragraph.add(str.substring(i, end).replaceAll("\t", "        ") + "\n");
                }
            }
            document.add((Element)paragraph);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (document != null) {
                document.close();
            }
            if (pdfOut != null) {
                ((OutputStream)pdfOut).close();
            }
        }
        FileInputStream pdfStream = new FileInputStream(tempFilePath);
        logger.debug("text2Pdf success, cost time:" + (System.currentTimeMillis() - start));
        return pdfStream;
    }
}

