/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.watermark;

import java.util.HashMap;
import java.util.Map;
import kd.bos.fileservice.watermark.ExcelWatermarkHandler;
import kd.bos.fileservice.watermark.GifImageWatermarkHandler;
import kd.bos.fileservice.watermark.IWatermarkHandler;
import kd.bos.fileservice.watermark.ImageWatermarkHandler;
import kd.bos.fileservice.watermark.PdfWatermarkHandler;
import kd.bos.fileservice.watermark.PdfWatermarkHandler2;
import kd.bos.fileservice.watermark.TxtWatermarkHandler;

public class WatermarkHandlerFactory {
    private static final String TXT_EXT = "txt";
    private static final String IMG_EXT = "bmp,gif,jpg,png,jpeg,dib,emf,jfif,jpe,rle,wmf,tif,pcx,tga,exif,fpx,svg,psd,cdr,pcd,dxf,ufo,eps,ai,raw,webp,avif";
    private static final String PDF_EXT = "pdf";
    private static final String WORD_EXT = "doc,docx";
    private static final String PPT_EXT = "ppt,pptx";
    public static final String VERSION_OPENPDF = "openPDF";
    public static final String VERSION_PDFBOX = "PDFBox";
    private static final Map<String, IWatermarkHandler> map = new HashMap<String, IWatermarkHandler>();

    public static IWatermarkHandler getHandler(String ext) {
        return WatermarkHandlerFactory.getHandler(ext, null);
    }

    public static IWatermarkHandler getHandler(String ext, String vFlag) {
        String ext_ = ext.toLowerCase();
        if (TXT_EXT.contains(ext_)) {
            return map.get("txtWatermarkHandler");
        }
        if (IMG_EXT.contains(ext_)) {
            if ("gif".equals(ext_)) {
                return map.get("gifImageWatermarkHandler");
            }
            return map.get("imageWatermarkHandler");
        }
        if (PDF_EXT.contains(ext_) || WORD_EXT.contains(ext_) || PPT_EXT.contains(ext_)) {
            IWatermarkHandler handler = map.get("pdfWatermarkHandler");
            if (vFlag != null && vFlag.equals(VERSION_PDFBOX)) {
                handler = map.get("pdfWatermarkHandler2");
            }
            return handler;
        }
        return null;
    }

    public static IWatermarkHandler getExcelHandler() {
        return map.get("excelWatermarkHandler");
    }

    static {
        map.put("txtWatermarkHandler", new TxtWatermarkHandler());
        map.put("pdfWatermarkHandler", new PdfWatermarkHandler());
        map.put("pdfWatermarkHandler2", new PdfWatermarkHandler2());
        map.put("imageWatermarkHandler", new ImageWatermarkHandler());
        map.put("gifImageWatermarkHandler", new GifImageWatermarkHandler());
        map.put("excelWatermarkHandler", new ExcelWatermarkHandler());
    }
}

