/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext;

import java.util.Arrays;
import kd.bos.fulltext.FTDataType;
import kd.bos.lang.Lang;

public class FTValue {
    private FTDataType dataType;
    private Lang fieldLang;
    private Object[] values;
    private boolean allAnd = true;
    private boolean isPinyinField = false;
    private float boost = 1.0f;

    private FTValue(Lang lang, FTDataType dataType) {
        this.fieldLang = lang;
        this.dataType = dataType;
    }

    public boolean isPinyin() {
        return this.isPinyinField;
    }

    public boolean isLang() {
        return !this.isPinyin() && this.fieldLang != null;
    }

    public Object[] getValues() {
        return this.values;
    }

    public FTDataType getDataType() {
        return this.dataType;
    }

    public Lang getLang() {
        return this.fieldLang;
    }

    public float getBoost() {
        return this.boost;
    }

    public boolean isOr() {
        return !this.allAnd;
    }

    public FTValue setOr() {
        this.allAnd = false;
        return this;
    }

    public FTValue setBoost(float boost) {
        this.boost = boost;
        return this;
    }

    public String toString() {
        if (this.values == null) {
            return "";
        }
        if (this.values.length == 1) {
            return String.valueOf(this.values[0]);
        }
        return Arrays.asList(this.values).toString();
    }

    public static FTValue pinyin(String ... values) {
        FTValue v = new FTValue(null, FTDataType.STRING);
        v.values = values;
        v.isPinyinField = true;
        return v;
    }

    public static FTValue lang(Lang lang, String ... values) {
        FTValue v = new FTValue(lang, FTDataType.STRING);
        v.values = values;
        return v;
    }

    public static FTValue normal(FTDataType dataType, Object ... values) {
        FTValue v = new FTValue(null, dataType);
        v.values = values;
        return v;
    }
}

