/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext;

import kd.bos.fulltext.FTDataType;
import kd.bos.fulltext.MatchProperty;
import kd.bos.lang.Lang;

public final class PropertyValue {
    private final String propertyName;
    private final FTDataType dataType;
    private final Lang lang;
    private final Object value;
    private boolean withPinyin;

    public PropertyValue(String propertyName, Lang lang, String value, boolean withPinyin) {
        this.propertyName = propertyName;
        this.dataType = FTDataType.STRING;
        this.lang = lang;
        this.withPinyin = withPinyin;
        this.value = value;
    }

    public PropertyValue(String propertyName, String value, boolean withPinyin) {
        this.propertyName = propertyName;
        this.dataType = FTDataType.STRING;
        this.lang = null;
        this.withPinyin = withPinyin;
        this.value = value;
    }

    public PropertyValue(String propertyName, FTDataType dataType, Object value) {
        this.propertyName = propertyName;
        this.dataType = dataType;
        this.lang = null;
        this.value = value;
        this.withPinyin = false;
    }

    public PropertyValue(MatchProperty mp, Object value) {
        this.propertyName = mp.getPropertyName();
        this.dataType = mp.getDataType();
        this.lang = null;
        this.value = value;
        this.withPinyin = false;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Lang getLang() {
        return this.lang;
    }

    public FTDataType getDataType() {
        return this.dataType;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isWithPinyin() {
        return this.withPinyin;
    }

    public String toString() {
        return "PropertyValue [propertyName=" + this.propertyName + ", dataType=" + (Object)((Object)this.dataType) + ", lang=" + this.lang + ", value=" + this.value + ", withPinyin=" + this.withPinyin + "]";
    }
}

